/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.NoopQuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaLimiterFactory;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class QuotaState {
    protected long lastUpdate = 0L;
    protected long lastQuery = 0L;
    protected QuotaLimiter globalLimiter = NoopQuotaLimiter.get();

    public QuotaState() {
        this(0L);
    }

    public QuotaState(long updateTs) {
        this.lastUpdate = updateTs;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public synchronized long getLastQuery() {
        return this.lastQuery;
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("QuotaState(ts=" + this.lastUpdate);
        if (this.isBypass()) {
            builder.append(" bypass");
        } else if (this.globalLimiter != NoopQuotaLimiter.get()) {
            builder.append(" " + this.globalLimiter);
        }
        builder.append(')');
        return builder.toString();
    }

    public synchronized boolean isBypass() {
        return this.globalLimiter == NoopQuotaLimiter.get();
    }

    public void setQuotas(QuotaProtos.Quotas quotas) {
        this.globalLimiter = quotas.hasThrottle() ? QuotaLimiterFactory.fromThrottle(quotas.getThrottle()) : NoopQuotaLimiter.get();
    }

    public synchronized void update(QuotaState other) {
        this.globalLimiter = this.globalLimiter == NoopQuotaLimiter.get() ? other.globalLimiter : (other.globalLimiter == NoopQuotaLimiter.get() ? NoopQuotaLimiter.get() : QuotaLimiterFactory.update(this.globalLimiter, other.globalLimiter));
        this.lastUpdate = other.lastUpdate;
    }

    public synchronized QuotaLimiter getGlobalLimiter() {
        this.lastQuery = EnvironmentEdgeManager.currentTime();
        return this.globalLimiter;
    }
}

