/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.regionserver.RegionReplicaReplicationEndpoint;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;

public class ServerRegionReplicaUtil
extends RegionReplicaUtil {
    public static final String REGION_REPLICA_REPLICATION_CONF_KEY = "hbase.region.replica.replication.enabled";
    private static final boolean DEFAULT_REGION_REPLICA_REPLICATION = false;
    private static final String REGION_REPLICA_REPLICATION_PEER = "region_replica_replication";

    public static HRegionInfo getRegionInfoForFs(HRegionInfo regionInfo) {
        if (regionInfo == null) {
            return null;
        }
        return RegionReplicaUtil.getRegionInfoForDefaultReplica((HRegionInfo)regionInfo);
    }

    public static boolean isReadOnly(HRegion region) {
        return region.getTableDesc().isReadOnly() || !ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
    }

    public static boolean shouldReplayRecoveredEdits(HRegion region) {
        return ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
    }

    public static StoreFileInfo getStoreFileInfo(Configuration conf, FileSystem fs, HRegionInfo regionInfo, HRegionInfo regionInfoForFs, String familyName, Path path) throws IOException {
        if (regionInfo.equals((Object)regionInfoForFs)) {
            return new StoreFileInfo(conf, fs, path);
        }
        HFileLink link = HFileLink.build(conf, regionInfoForFs.getTable(), regionInfoForFs.getEncodedName(), familyName, path.getName());
        if (StoreFileInfo.isReference(path)) {
            Reference reference = Reference.read(fs, path);
            return new StoreFileInfo(conf, fs, link.getFileStatus(fs), reference);
        }
        return new StoreFileInfo(conf, fs, link.getFileStatus(fs), link);
    }

    public static void setupRegionReplicaReplication(Configuration conf) throws IOException {
        if (!conf.getBoolean(REGION_REPLICA_REPLICATION_CONF_KEY, false)) {
            return;
        }
        try (ReplicationAdmin repAdmin = new ReplicationAdmin(conf);){
            if (repAdmin.getPeerConfig(REGION_REPLICA_REPLICATION_PEER) == null) {
                ReplicationPeerConfig peerConfig = new ReplicationPeerConfig();
                peerConfig.setClusterKey(ZKUtil.getZooKeeperClusterKey((Configuration)conf));
                peerConfig.setReplicationEndpointImpl(RegionReplicaReplicationEndpoint.class.getName());
                repAdmin.addPeer(REGION_REPLICA_REPLICATION_PEER, peerConfig, null);
            }
        }
    }

    public static String getReplicationPeerId() {
        return REGION_REPLICA_REPLICATION_PEER;
    }
}

