/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CartesianProductEnumerator<T>
implements Enumerator<List<T>> {
    private final List<Enumerator<T>> enumerators;
    private final T[] elements;
    private boolean first = true;

    public CartesianProductEnumerator(List<Enumerator<T>> enumerators) {
        this.enumerators = enumerators;
        this.elements = new Object[enumerators.size()];
    }

    @Override
    public List<T> current() {
        return Arrays.asList((Object[])this.elements.clone());
    }

    @Override
    public boolean moveNext() {
        if (this.first) {
            int i = 0;
            for (Enumerator<T> enumerator : this.enumerators) {
                if (!enumerator.moveNext()) {
                    return false;
                }
                this.elements[i++] = enumerator.current();
            }
            this.first = false;
            return true;
        }
        for (int ordinal = this.enumerators.size() - 1; ordinal >= 0; --ordinal) {
            Enumerator<T> enumerator = this.enumerators.get(ordinal);
            if (enumerator.moveNext()) {
                this.elements[ordinal] = enumerator.current();
                return true;
            }
            enumerator.reset();
            if (!enumerator.moveNext()) {
                return false;
            }
            this.elements[ordinal] = enumerator.current();
        }
        return false;
    }

    @Override
    public void reset() {
        this.first = true;
    }

    @Override
    public void close() {
        Throwable rte = null;
        for (Enumerator<T> enumerator : this.enumerators) {
            try {
                enumerator.close();
            }
            catch (Throwable e) {
                rte = e;
            }
        }
        if (rte != null) {
            if (rte instanceof Error) {
                throw (Error)rte;
            }
            throw (RuntimeException)rte;
        }
    }
}

