/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.CompressedSplitLineReader;
import org.apache.hadoop.mapreduce.lib.input.SplitLineReader;

public class LineRecordReader
implements RecordReader<LongWritable, Text> {
    private static final Log LOG = LogFactory.getLog((String)LineRecordReader.class.getName());
    private CompressionCodecFactory compressionCodecs = null;
    private long start;
    private long pos;
    private long end;
    private SplitLineReader in;
    int maxLineLength;
    private Seekable filePosition;
    private CompressionCodec codec;
    private Decompressor decompressor;

    public LineRecordReader(Configuration job, FileSplit split) throws IOException {
        this(job, split, null);
    }

    public LineRecordReader(Configuration job, FileSplit split, byte[] recordDelimiter) throws IOException {
        this.maxLineLength = job.getInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        this.compressionCodecs = new CompressionCodecFactory(job);
        this.codec = this.compressionCodecs.getCodec(file);
        FileSystem fs = file.getFileSystem(job);
        FSDataInputStream fileIn = fs.open(split.getPath());
        if (this.isCompressedInput()) {
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)this.codec);
            if (this.codec instanceof SplittableCompressionCodec) {
                SplitCompressionInputStream cIn = ((SplittableCompressionCodec)this.codec).createInputStream((InputStream)fileIn, this.decompressor, this.start, this.end, SplittableCompressionCodec.READ_MODE.BYBLOCK);
                this.in = new CompressedSplitLineReader(cIn, job, recordDelimiter);
                this.start = cIn.getAdjustedStart();
                this.end = cIn.getAdjustedEnd();
                this.filePosition = cIn;
            } else {
                this.in = new SplitLineReader((InputStream)this.codec.createInputStream((InputStream)fileIn, this.decompressor), job, recordDelimiter);
                this.filePosition = fileIn;
            }
        } else {
            fileIn.seek(this.start);
            this.in = new SplitLineReader((InputStream)fileIn, job, recordDelimiter);
            this.filePosition = fileIn;
        }
        if (this.start != 0L) {
            this.start += (long)this.in.readLine(new Text(), 0, this.maxBytesToConsume(this.start));
        }
        this.pos = this.start;
    }

    private boolean isCompressedInput() {
        return this.codec != null;
    }

    private int maxBytesToConsume(long pos) {
        return this.isCompressedInput() ? Integer.MAX_VALUE : (int)Math.max(Math.min(Integer.MAX_VALUE, this.end - pos), (long)this.maxLineLength);
    }

    private long getFilePosition() throws IOException {
        long retVal = this.isCompressedInput() && null != this.filePosition ? this.filePosition.getPos() : this.pos;
        return retVal;
    }

    private int skipUtfByteOrderMark(Text value) throws IOException {
        int newMaxLineLength = (int)Math.min(3L + (long)this.maxLineLength, Integer.MAX_VALUE);
        int newSize = this.in.readLine(value, newMaxLineLength, this.maxBytesToConsume(this.pos));
        this.pos += (long)newSize;
        int textLength = value.getLength();
        byte[] textBytes = value.getBytes();
        if (textLength >= 3 && textBytes[0] == -17 && textBytes[1] == -69 && textBytes[2] == -65) {
            LOG.info((Object)"Found UTF-8 BOM and skipped it");
            newSize -= 3;
            if ((textLength -= 3) > 0) {
                textBytes = value.copyBytes();
                value.set(textBytes, 3, textLength);
            } else {
                value.clear();
            }
        }
        return newSize;
    }

    public LineRecordReader(InputStream in, long offset, long endOffset, int maxLineLength) {
        this(in, offset, endOffset, maxLineLength, null);
    }

    public LineRecordReader(InputStream in, long offset, long endOffset, int maxLineLength, byte[] recordDelimiter) {
        this.maxLineLength = maxLineLength;
        this.in = new SplitLineReader(in, recordDelimiter);
        this.start = offset;
        this.pos = offset;
        this.end = endOffset;
        this.filePosition = null;
    }

    public LineRecordReader(InputStream in, long offset, long endOffset, Configuration job) throws IOException {
        this(in, offset, endOffset, job, null);
    }

    public LineRecordReader(InputStream in, long offset, long endOffset, Configuration job, byte[] recordDelimiter) throws IOException {
        this.maxLineLength = job.getInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        this.in = new SplitLineReader(in, job, recordDelimiter);
        this.start = offset;
        this.pos = offset;
        this.end = endOffset;
        this.filePosition = null;
    }

    @Override
    public LongWritable createKey() {
        return new LongWritable();
    }

    @Override
    public Text createValue() {
        return new Text();
    }

    @Override
    public synchronized boolean next(LongWritable key, Text value) throws IOException {
        while (this.getFilePosition() <= this.end || this.in.needAdditionalRecordAfterSplit()) {
            key.set(this.pos);
            int newSize = 0;
            if (this.pos == 0L) {
                newSize = this.skipUtfByteOrderMark(value);
            } else {
                newSize = this.in.readLine(value, this.maxLineLength, this.maxBytesToConsume(this.pos));
                this.pos += (long)newSize;
            }
            if (newSize == 0) {
                return false;
            }
            if (newSize < this.maxLineLength) {
                return true;
            }
            LOG.info((Object)("Skipped line of size " + newSize + " at pos " + (this.pos - (long)newSize)));
        }
        return false;
    }

    @Override
    public float getProgress() {
        if (this.start == this.end) {
            return 0.0f;
        }
        try {
            return Math.min(1.0f, (float)(this.getFilePosition() - this.start) / (float)(this.end - this.start));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        finally {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
            }
        }
    }

    @Deprecated
    public static class LineReader
    extends org.apache.hadoop.util.LineReader {
        LineReader(InputStream in) {
            super(in);
        }

        LineReader(InputStream in, int bufferSize) {
            super(in, bufferSize);
        }

        public LineReader(InputStream in, Configuration conf) throws IOException {
            super(in, conf);
        }

        LineReader(InputStream in, byte[] recordDelimiter) {
            super(in, recordDelimiter);
        }

        LineReader(InputStream in, int bufferSize, byte[] recordDelimiter) {
            super(in, bufferSize, recordDelimiter);
        }

        public LineReader(InputStream in, Configuration conf, byte[] recordDelimiter) throws IOException {
            super(in, conf, recordDelimiter);
        }
    }
}

