/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public interface ShuffleConsumerPlugin {
    public void init(Context var1) throws ClassNotFoundException, IOException;

    public boolean fetchOutputs() throws IOException;

    public RawKeyValueIterator createKVIterator() throws IOException;

    public void close();

    public Throwable getMergeThrowable();

    public static class Context {
        private final TaskUmbilicalProtocol umbilical;
        private final JobConf jobConf;
        private final Task.TaskReporter reporter;
        private final ReduceTask reduceTask;

        public Context(TaskUmbilicalProtocol umbilical, JobConf conf, Task.TaskReporter reporter, ReduceTask reduceTask) {
            this.umbilical = umbilical;
            this.jobConf = conf;
            this.reporter = reporter;
            this.reduceTask = reduceTask;
        }

        public TaskUmbilicalProtocol getUmbilical() {
            return this.umbilical;
        }

        public JobConf getJobConf() {
            return this.jobConf;
        }

        public Task.TaskReporter getReporter() {
            return this.reporter;
        }

        public ReduceTask getReduceTask() {
            return this.reduceTask;
        }
    }
}

