/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.Chain;

public class ChainReducer
implements Reducer {
    private Chain chain = new Chain(false);

    public static <K1, V1, K2, V2> void setReducer(JobConf job, Class<? extends Reducer<K1, V1, K2, V2>> klass, Class<? extends K1> inputKeyClass, Class<? extends V1> inputValueClass, Class<? extends K2> outputKeyClass, Class<? extends V2> outputValueClass, boolean byValue, JobConf reducerConf) {
        job.setReducerClass(ChainReducer.class);
        job.setOutputKeyClass(outputKeyClass);
        job.setOutputValueClass(outputValueClass);
        Chain.setReducer(job, klass, inputKeyClass, inputValueClass, outputKeyClass, outputValueClass, byValue, reducerConf);
    }

    public static <K1, V1, K2, V2> void addMapper(JobConf job, Class<? extends Mapper<K1, V1, K2, V2>> klass, Class<? extends K1> inputKeyClass, Class<? extends V1> inputValueClass, Class<? extends K2> outputKeyClass, Class<? extends V2> outputValueClass, boolean byValue, JobConf mapperConf) {
        job.setOutputKeyClass(outputKeyClass);
        job.setOutputValueClass(outputValueClass);
        Chain.addMapper(false, job, klass, inputKeyClass, inputValueClass, outputKeyClass, outputValueClass, byValue, mapperConf);
    }

    @Override
    public void configure(JobConf job) {
        this.chain.configure(job);
    }

    public void reduce(Object key, Iterator values, OutputCollector output, Reporter reporter) throws IOException {
        Reducer reducer = this.chain.getReducer();
        if (reducer != null) {
            reducer.reduce(key, values, this.chain.getReducerCollector(output, reporter), reporter);
        }
    }

    public void close() throws IOException {
        this.chain.close();
    }
}

