/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class SequenceFileAsBinaryOutputFormat
extends SequenceFileOutputFormat<BytesWritable, BytesWritable> {
    public static String KEY_CLASS = "mapreduce.output.seqbinaryoutputformat.key.class";
    public static String VALUE_CLASS = "mapreduce.output.seqbinaryoutputformat.value.class";

    public static void setSequenceFileOutputKeyClass(Job job, Class<?> theClass) {
        job.getConfiguration().setClass(KEY_CLASS, theClass, Object.class);
    }

    public static void setSequenceFileOutputValueClass(Job job, Class<?> theClass) {
        job.getConfiguration().setClass(VALUE_CLASS, theClass, Object.class);
    }

    public static Class<? extends WritableComparable> getSequenceFileOutputKeyClass(JobContext job) {
        return job.getConfiguration().getClass(KEY_CLASS, job.getOutputKeyClass().asSubclass(WritableComparable.class), WritableComparable.class);
    }

    public static Class<? extends Writable> getSequenceFileOutputValueClass(JobContext job) {
        return job.getConfiguration().getClass(VALUE_CLASS, job.getOutputValueClass().asSubclass(Writable.class), Writable.class);
    }

    @Override
    public RecordWriter<BytesWritable, BytesWritable> getRecordWriter(TaskAttemptContext context) throws IOException {
        final SequenceFile.Writer out = this.getSequenceWriter(context, SequenceFileAsBinaryOutputFormat.getSequenceFileOutputKeyClass(context), SequenceFileAsBinaryOutputFormat.getSequenceFileOutputValueClass(context));
        return new RecordWriter<BytesWritable, BytesWritable>(){
            private WritableValueBytes wvaluebytes = new WritableValueBytes();

            @Override
            public void write(BytesWritable bkey, BytesWritable bvalue) throws IOException {
                this.wvaluebytes.reset(bvalue);
                out.appendRaw(bkey.getBytes(), 0, bkey.getLength(), (SequenceFile.ValueBytes)this.wvaluebytes);
                this.wvaluebytes.reset(null);
            }

            @Override
            public void close(TaskAttemptContext context) throws IOException {
                out.close();
            }
        };
    }

    protected SequenceFile.Writer getSequenceWriter(TaskAttemptContext context, Class<?> keyClass, Class<?> valueClass) throws IOException {
        Configuration conf = context.getConfiguration();
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (SequenceFileAsBinaryOutputFormat.getCompressOutput(context)) {
            compressionType = SequenceFileAsBinaryOutputFormat.getOutputCompressionType(context);
            Class<CompressionCodec> codecClass = SequenceFileAsBinaryOutputFormat.getOutputCompressorClass(context, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)conf);
        }
        Path file = this.getDefaultWorkFile(context, "");
        FileSystem fs = file.getFileSystem(conf);
        return SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, keyClass, valueClass, (SequenceFile.CompressionType)compressionType, (CompressionCodec)codec, (Progressable)context);
    }

    @Override
    public void checkOutputSpecs(JobContext job) throws IOException {
        super.checkOutputSpecs(job);
        if (SequenceFileAsBinaryOutputFormat.getCompressOutput(job) && SequenceFileAsBinaryOutputFormat.getOutputCompressionType(job) == SequenceFile.CompressionType.RECORD) {
            throw new InvalidJobConfException("SequenceFileAsBinaryOutputFormat doesn't support Record Compression");
        }
    }

    public static class WritableValueBytes
    implements SequenceFile.ValueBytes {
        private BytesWritable value;

        public WritableValueBytes() {
            this.value = null;
        }

        public WritableValueBytes(BytesWritable value) {
            this.value = value;
        }

        public void reset(BytesWritable value) {
            this.value = value;
        }

        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
            outStream.write(this.value.getBytes(), 0, this.value.getLength());
        }

        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            throw new UnsupportedOperationException("WritableValueBytes doesn't support RECORD compression");
        }

        public int getSize() {
            return this.value.getLength();
        }
    }
}

