/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.AbstractPrimitiveLazyObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyByteObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDateObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyFloatObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyShortObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyVoidObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public final class LazyPrimitiveObjectInspectorFactory {
    public static final LazyBooleanObjectInspector LAZY_BOOLEAN_OBJECT_INSPECTOR = new LazyBooleanObjectInspector();
    public static final LazyBooleanObjectInspector LAZY_EXT_BOOLEAN_OBJECT_INSPECTOR = new LazyBooleanObjectInspector();
    public static final LazyByteObjectInspector LAZY_BYTE_OBJECT_INSPECTOR;
    public static final LazyShortObjectInspector LAZY_SHORT_OBJECT_INSPECTOR;
    public static final LazyIntObjectInspector LAZY_INT_OBJECT_INSPECTOR;
    public static final LazyLongObjectInspector LAZY_LONG_OBJECT_INSPECTOR;
    public static final LazyFloatObjectInspector LAZY_FLOAT_OBJECT_INSPECTOR;
    public static final LazyDoubleObjectInspector LAZY_DOUBLE_OBJECT_INSPECTOR;
    public static final LazyVoidObjectInspector LAZY_VOID_OBJECT_INSPECTOR;
    public static final LazyDateObjectInspector LAZY_DATE_OBJECT_INSPECTOR;
    public static final LazyTimestampObjectInspector LAZY_TIMESTAMP_OBJECT_INSPECTOR;
    public static final LazyBinaryObjectInspector LAZY_BINARY_OBJECT_INSPECTOR;
    private static ConcurrentHashMap<ArrayList<Object>, AbstractPrimitiveLazyObjectInspector<?>> cachedLazyStringTypeOIs;
    private static ConcurrentHashMap<PrimitiveTypeInfo, AbstractPrimitiveLazyObjectInspector<?>> cachedPrimitiveLazyObjectInspectors;

    private LazyPrimitiveObjectInspectorFactory() {
    }

    public static AbstractPrimitiveLazyObjectInspector<?> getLazyObjectInspector(PrimitiveTypeInfo typeInfo, boolean escaped, byte escapeChar) {
        return LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector(typeInfo, escaped, escapeChar, false);
    }

    public static AbstractPrimitiveLazyObjectInspector<?> getLazyObjectInspector(PrimitiveTypeInfo typeInfo, boolean escaped, byte escapeChar, boolean extBoolean) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
        switch (primitiveCategory) {
            case STRING: {
                return LazyPrimitiveObjectInspectorFactory.getLazyStringObjectInspector(escaped, escapeChar);
            }
            case CHAR: {
                return LazyPrimitiveObjectInspectorFactory.getLazyHiveCharObjectInspector((CharTypeInfo)typeInfo, escaped, escapeChar);
            }
            case VARCHAR: {
                return LazyPrimitiveObjectInspectorFactory.getLazyHiveVarcharObjectInspector((VarcharTypeInfo)typeInfo, escaped, escapeChar);
            }
            case BOOLEAN: {
                return LazyPrimitiveObjectInspectorFactory.getLazyBooleanObjectInspector(extBoolean);
            }
        }
        return LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector(typeInfo);
    }

    public static AbstractPrimitiveLazyObjectInspector<?> getLazyObjectInspector(PrimitiveTypeInfo typeInfo) {
        AbstractPrimitiveLazyObjectInspector poi = cachedPrimitiveLazyObjectInspectors.get(typeInfo);
        if (poi != null) {
            return poi;
        }
        switch (typeInfo.getPrimitiveCategory()) {
            case CHAR: {
                poi = new LazyHiveCharObjectInspector((CharTypeInfo)typeInfo);
                break;
            }
            case VARCHAR: {
                poi = new LazyHiveVarcharObjectInspector((VarcharTypeInfo)typeInfo);
                break;
            }
            case DECIMAL: {
                poi = new LazyHiveDecimalObjectInspector((DecimalTypeInfo)typeInfo);
                break;
            }
            default: {
                throw new RuntimeException("Primitve type " + (Object)((Object)typeInfo.getPrimitiveCategory()) + " should not take parameters");
            }
        }
        AbstractPrimitiveLazyObjectInspector prev = cachedPrimitiveLazyObjectInspectors.putIfAbsent(typeInfo, poi);
        if (prev != null) {
            poi = prev;
        }
        return poi;
    }

    public static LazyStringObjectInspector getLazyStringObjectInspector(boolean escaped, byte escapeChar) {
        AbstractPrimitiveLazyObjectInspector prev;
        ArrayList<Serializable> signature = new ArrayList<Serializable>();
        signature.add(TypeInfoFactory.stringTypeInfo);
        signature.add(Boolean.valueOf(escaped));
        signature.add(Byte.valueOf(escapeChar));
        LazyStringObjectInspector result = (LazyStringObjectInspector)cachedLazyStringTypeOIs.get(signature);
        if (result == null && (prev = (AbstractPrimitiveLazyObjectInspector)cachedLazyStringTypeOIs.putIfAbsent(signature, result = new LazyStringObjectInspector(escaped, escapeChar))) != null) {
            result = (LazyStringObjectInspector)prev;
        }
        return result;
    }

    public static LazyHiveCharObjectInspector getLazyHiveCharObjectInspector(CharTypeInfo typeInfo, boolean escaped, byte escapeChar) {
        AbstractPrimitiveLazyObjectInspector prev;
        ArrayList<Serializable> signature = new ArrayList<Serializable>();
        signature.add(typeInfo);
        signature.add(Boolean.valueOf(escaped));
        signature.add(Byte.valueOf(escapeChar));
        LazyHiveCharObjectInspector result = (LazyHiveCharObjectInspector)cachedLazyStringTypeOIs.get(signature);
        if (result == null && (prev = (AbstractPrimitiveLazyObjectInspector)cachedLazyStringTypeOIs.putIfAbsent(signature, result = new LazyHiveCharObjectInspector(typeInfo, escaped, escapeChar))) != null) {
            result = (LazyHiveCharObjectInspector)prev;
        }
        return result;
    }

    public static LazyHiveVarcharObjectInspector getLazyHiveVarcharObjectInspector(VarcharTypeInfo typeInfo, boolean escaped, byte escapeChar) {
        AbstractPrimitiveLazyObjectInspector prev;
        ArrayList<Serializable> signature = new ArrayList<Serializable>();
        signature.add(typeInfo);
        signature.add(Boolean.valueOf(escaped));
        signature.add(Byte.valueOf(escapeChar));
        LazyHiveVarcharObjectInspector result = (LazyHiveVarcharObjectInspector)cachedLazyStringTypeOIs.get(signature);
        if (result == null && (prev = (AbstractPrimitiveLazyObjectInspector)cachedLazyStringTypeOIs.putIfAbsent(signature, result = new LazyHiveVarcharObjectInspector(typeInfo, escaped, escapeChar))) != null) {
            result = (LazyHiveVarcharObjectInspector)prev;
        }
        return result;
    }

    private static LazyBooleanObjectInspector getLazyBooleanObjectInspector(boolean extLiteral) {
        return extLiteral ? LAZY_EXT_BOOLEAN_OBJECT_INSPECTOR : LAZY_BOOLEAN_OBJECT_INSPECTOR;
    }

    static {
        LAZY_EXT_BOOLEAN_OBJECT_INSPECTOR.setExtendedLiteral(true);
        LAZY_BYTE_OBJECT_INSPECTOR = new LazyByteObjectInspector();
        LAZY_SHORT_OBJECT_INSPECTOR = new LazyShortObjectInspector();
        LAZY_INT_OBJECT_INSPECTOR = new LazyIntObjectInspector();
        LAZY_LONG_OBJECT_INSPECTOR = new LazyLongObjectInspector();
        LAZY_FLOAT_OBJECT_INSPECTOR = new LazyFloatObjectInspector();
        LAZY_DOUBLE_OBJECT_INSPECTOR = new LazyDoubleObjectInspector();
        LAZY_VOID_OBJECT_INSPECTOR = new LazyVoidObjectInspector();
        LAZY_DATE_OBJECT_INSPECTOR = new LazyDateObjectInspector();
        LAZY_TIMESTAMP_OBJECT_INSPECTOR = new LazyTimestampObjectInspector();
        LAZY_BINARY_OBJECT_INSPECTOR = new LazyBinaryObjectInspector();
        cachedLazyStringTypeOIs = new ConcurrentHashMap();
        cachedPrimitiveLazyObjectInspectors = new ConcurrentHashMap();
        cachedPrimitiveLazyObjectInspectors.put(TypeInfoFactory.getPrimitiveTypeInfo("boolean"), LAZY_BOOLEAN_OBJECT_INSPECTOR);
        cachedPrimitiveLazyObjectInspectors.put(TypeInfoFactory.getPrimitiveTypeInfo("tinyint"), LAZY_BYTE_OBJECT_INSPECTOR);
        cachedPrimitiveLazyObjectInspectors.put(TypeInfoFactory.getPrimitiveTypeInfo("smallint"), LAZY_SHORT_OBJECT_INSPECTOR);
        cachedPrimitiveLazyObjectInspectors.put(TypeInfoFactory.getPrimitiveTypeInfo("int"), LAZY_INT_OBJECT_INSPECTOR);
        cachedPrimitiveLazyObjectInspectors.put(TypeInfoFactory.getPrimitiveTypeInfo("float"), LAZY_FLOAT_OBJECT_INSPECTOR);
        cachedPrimitiveLazyObjectInspectors.put(TypeInfoFactory.getPrimitiveTypeInfo("double"), LAZY_DOUBLE_OBJECT_INSPECTOR);
        cachedPrimitiveLazyObjectInspectors.put(TypeInfoFactory.getPrimitiveTypeInfo("bigint"), LAZY_LONG_OBJECT_INSPECTOR);
        cachedPrimitiveLazyObjectInspectors.put(TypeInfoFactory.getPrimitiveTypeInfo("void"), LAZY_VOID_OBJECT_INSPECTOR);
        cachedPrimitiveLazyObjectInspectors.put(TypeInfoFactory.getPrimitiveTypeInfo("date"), LAZY_DATE_OBJECT_INSPECTOR);
        cachedPrimitiveLazyObjectInspectors.put(TypeInfoFactory.getPrimitiveTypeInfo("timestamp"), LAZY_TIMESTAMP_OBJECT_INSPECTOR);
        cachedPrimitiveLazyObjectInspectors.put(TypeInfoFactory.getPrimitiveTypeInfo("binary"), LAZY_BINARY_OBJECT_INSPECTOR);
    }
}

