/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.mapreduce;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.TypeNotFoundException;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.data.spi.InputFormatAccessor;
import org.kitesdk.data.spi.PartitionKey;
import org.kitesdk.data.spi.PartitionedDataset;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetKeyInputFormat<E>
extends InputFormat<E, Void>
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(DatasetKeyInputFormat.class);
    public static final String KITE_INPUT_URI = "kite.inputUri";
    public static final String KITE_PARTITION_DIR = "kite.inputPartitionDir";
    public static final String KITE_TYPE = "kite.inputEntityType";
    public static final String KITE_READER_SCHEMA = "kite.readerSchema";
    private Configuration conf;
    private InputFormat<E, Void> delegate;

    public static ConfigBuilder configure(Job job) {
        job.setInputFormatClass(DatasetKeyInputFormat.class);
        Configuration conf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)job, new Object[0]);
        return new ConfigBuilder(conf);
    }

    public static ConfigBuilder configure(Configuration conf) {
        DatasetKeyInputFormat.setInputFormatClass(conf);
        return new ConfigBuilder(conf);
    }

    private static void setInputFormatClass(Configuration conf) {
        if (Hadoop.isHadoop1()) {
            conf.set("mapreduce.inputformat.class", DatasetKeyInputFormat.class.getName());
        } else {
            Job fakeJob = (Job)Hadoop.Job.newInstance.invoke(new Object[]{new Configuration(false)});
            fakeJob.setInputFormatClass(DatasetKeyInputFormat.class);
            for (Map.Entry entry : fakeJob.getConfiguration()) {
                conf.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        View<E> view = DatasetKeyInputFormat.load(configuration);
        String partitionDir = this.conf.get(KITE_PARTITION_DIR);
        this.delegate = view.getDataset().getDescriptor().isPartitioned() && partitionDir != null ? this.getDelegateInputFormatForPartition(view.getDataset(), partitionDir, this.conf) : this.getDelegateInputFormat(view, this.conf);
    }

    private InputFormat<E, Void> getDelegateInputFormat(View<E> view, Configuration conf) {
        if (view instanceof InputFormatAccessor) {
            return ((InputFormatAccessor)view).getInputFormat(conf);
        }
        throw new UnsupportedOperationException("Implementation does not provide InputFormat support. View: " + view);
    }

    private InputFormat<E, Void> getDelegateInputFormatForPartition(Dataset<E> dataset, String partitionDir, Configuration conf) {
        if (!(dataset instanceof FileSystemDataset)) {
            throw new UnsupportedOperationException("Partitions only supported for FileSystemDataset. Dataset: " + dataset);
        }
        FileSystemDataset fsDataset = (FileSystemDataset)dataset;
        LOG.debug("Getting delegate input format for dataset {} with partition directory {}", dataset, (Object)partitionDir);
        PartitionKey key = fsDataset.keyFromDirectory(new Path(partitionDir));
        LOG.debug("Partition key: {}", (Object)key);
        if (key != null) {
            PartitionedDataset partition = fsDataset.getPartition(key, false);
            LOG.debug("Partition: {}", (Object)partition);
            return this.getDelegateInputFormat((View<E>)partition, conf);
        }
        throw new DatasetException("Cannot find partition " + partitionDir);
    }

    private static <E> View<E> load(Configuration conf) {
        Class type;
        try {
            type = conf.getClass(KITE_TYPE, GenericData.Record.class);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw new TypeNotFoundException(String.format("The Java class %s for the entity type could not be found", conf.get(KITE_TYPE)), e.getCause());
            }
            throw e;
        }
        String schemaStr = conf.get(KITE_READER_SCHEMA);
        Schema projection = null;
        if (schemaStr != null) {
            projection = new Schema.Parser().parse(schemaStr);
        }
        String inputUri = conf.get(KITE_INPUT_URI);
        if (projection != null) {
            return Datasets.load((String)inputUri).asSchema(projection).asType(type);
        }
        return Datasets.load((String)inputUri, (Class)type);
    }

    @SuppressWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Delegate set by setConf")
    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.delegate.getSplits(jobContext);
    }

    @SuppressWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Delegate set by setConf")
    public RecordReader<E, Void> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration conf = (Configuration)Hadoop.TaskAttemptContext.getConfiguration.invoke((Object)taskAttemptContext, new Object[0]);
        DefaultConfiguration.init((Configuration)conf);
        return this.delegate.createRecordReader(inputSplit, taskAttemptContext);
    }

    public static class ConfigBuilder {
        private final Configuration conf;

        private ConfigBuilder(Configuration conf) {
            this.conf = conf;
        }

        public ConfigBuilder readFrom(URI uri) {
            return this.readFrom(Datasets.load((URI)uri));
        }

        public ConfigBuilder readFrom(View<?> view) {
            DatasetDescriptor descriptor = view.getDataset().getDescriptor();
            if (view instanceof FileSystemDataset) {
                this.conf.set(DatasetKeyInputFormat.KITE_PARTITION_DIR, String.valueOf(descriptor.getLocation()));
            }
            for (String property : descriptor.listProperties()) {
                this.conf.set(property, descriptor.getProperty(property));
            }
            if (DataModelUtil.isGeneric((Class)view.getType())) {
                Schema datasetSchema = view.getDataset().getDescriptor().getSchema();
                if (!datasetSchema.equals((Object)view.getSchema())) {
                    this.withSchema(view.getSchema());
                }
            } else {
                this.withType(view.getType());
            }
            this.conf.set(DatasetKeyInputFormat.KITE_INPUT_URI, view.getUri().toString());
            return this;
        }

        public ConfigBuilder readFrom(String uri) {
            return this.readFrom(URI.create(uri));
        }

        public <E> ConfigBuilder withType(Class<E> type) {
            String readerSchema = this.conf.get(DatasetKeyInputFormat.KITE_READER_SCHEMA);
            Preconditions.checkArgument(DataModelUtil.isGeneric(type) || readerSchema == null, "Can't configure a type when a reader schema is already set: {}", readerSchema);
            this.conf.setClass(DatasetKeyInputFormat.KITE_TYPE, type, type);
            return this;
        }

        public ConfigBuilder withSchema(Schema readerSchema) {
            Class type = this.conf.getClass(DatasetKeyInputFormat.KITE_TYPE, null);
            Preconditions.checkArgument(type == null || DataModelUtil.isGeneric((Class)type), "Can't configure a reader schema when a type is already set: {}", type);
            this.conf.set(DatasetKeyInputFormat.KITE_READER_SCHEMA, readerSchema.toString());
            return this;
        }
    }
}

