/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActorAction;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActorActionException;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.ipc.StandbyException;

public class ReportBadBlockAction
implements BPServiceActorAction {
    private final ExtendedBlock block;
    private final String storageUuid;
    private final StorageType storageType;

    public ReportBadBlockAction(ExtendedBlock block, String storageUuid, StorageType storageType) {
        this.block = block;
        this.storageUuid = storageUuid;
        this.storageType = storageType;
    }

    @Override
    public void reportTo(DatanodeProtocolClientSideTranslatorPB bpNamenode, DatanodeRegistration bpRegistration) throws BPServiceActorActionException {
        if (bpRegistration == null) {
            return;
        }
        DatanodeInfo[] dnArr = new DatanodeInfo[]{new DatanodeInfo(bpRegistration)};
        String[] uuids = new String[]{this.storageUuid};
        StorageType[] types = new StorageType[]{this.storageType};
        LocatedBlock[] locatedBlock = new LocatedBlock[]{new LocatedBlock(this.block, dnArr, uuids, types)};
        try {
            bpNamenode.reportBadBlocks(locatedBlock);
        }
        catch (StandbyException e) {
            DataNode.LOG.warn((Object)("Failed to report bad block " + this.block + " to standby namenode"));
        }
        catch (IOException e) {
            throw new BPServiceActorActionException("Failed to report bad block " + this.block + " to namenode: ");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
        result = 31 * result + (this.storageType == null ? 0 : this.storageType.hashCode());
        result = 31 * result + (this.storageUuid == null ? 0 : this.storageUuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ReportBadBlockAction)) {
            return false;
        }
        ReportBadBlockAction other = (ReportBadBlockAction)obj;
        if (this.block == null ? other.block != null : !this.block.equals(other.block)) {
            return false;
        }
        if (this.storageType != other.storageType) {
            return false;
        }
        return !(this.storageUuid == null ? other.storageUuid != null : !this.storageUuid.equals(other.storageUuid));
    }
}

