/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.io.IOUtils;

public class ReplicaInputStreams
implements Closeable {
    private final InputStream dataIn;
    private final InputStream checksumIn;
    private final FsVolumeReference volumeRef;

    public ReplicaInputStreams(FileDescriptor dataFd, FileDescriptor checksumFd, FsVolumeReference volumeRef) {
        this.volumeRef = volumeRef;
        this.dataIn = new FileInputStream(dataFd);
        this.checksumIn = new FileInputStream(checksumFd);
    }

    public InputStream getDataIn() {
        return this.dataIn;
    }

    public InputStream getChecksumIn() {
        return this.checksumIn;
    }

    @Override
    public void close() {
        IOUtils.closeStream((Closeable)this.dataIn);
        IOUtils.closeStream((Closeable)this.checksumIn);
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.volumeRef});
    }
}

