/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.AuthorizationProvider;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.Token;

public class AuthorizationProviderProxyClientProtocol
implements ClientProtocol {
    private ClientProtocol server;

    public AuthorizationProviderProxyClientProtocol(ClientProtocol server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            LocatedBlocks locatedBlocks = this.server.getBlockLocations(src, offset, length);
            return locatedBlocks;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.server.getServerDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions) throws AccessControlException, AlreadyBeingCreatedException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            HdfsFileStatus hdfsFileStatus = this.server.create(src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions);
            return hdfsFileStatus;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocatedBlock append(String src, String clientName) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            LocatedBlock locatedBlock = this.server.append(src, clientName);
            return locatedBlock;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setReplication(String src, short replication) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            boolean bl = this.server.setReplication(src, replication);
            return bl;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            BlockStoragePolicy[] blockStoragePolicyArray = this.server.getStoragePolicies();
            return blockStoragePolicyArray;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStoragePolicy(String src, String policyName) throws SnapshotAccessControlException, UnresolvedLinkException, FileNotFoundException, QuotaExceededException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.setStoragePolicy(src, policyName);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermission(String src, FsPermission permission) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.setPermission(src, permission);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOwner(String src, String username, String groupname) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.setOwner(src, username, groupname);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.abandonBlock(b, fileId, src, holder);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludeNodes, long fileId, String[] favoredNodes) throws AccessControlException, FileNotFoundException, NotReplicatedYetException, SafeModeException, UnresolvedLinkException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            LocatedBlock locatedBlock = this.server.addBlock(src, clientName, previous, excludeNodes, fileId, favoredNodes);
            return locatedBlock;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            LocatedBlock locatedBlock = this.server.getAdditionalDatanode(src, fileId, blk, existings, existingStorageIDs, excludes, numAdditionalNodes, clientName);
            return locatedBlock;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            boolean bl = this.server.complete(src, clientName, last, fileId);
            return bl;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.reportBadBlocks(blocks);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(String src, String dst) throws UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            boolean bl = this.server.rename(src, dst);
            return bl;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void concat(String trg, String[] srcs) throws IOException, UnresolvedLinkException, SnapshotAccessControlException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.concat(trg, srcs);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws AccessControlException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.rename2(src, dst, options);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String src, boolean recursive) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            boolean bl = this.server.delete(src, recursive);
            return bl;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            boolean bl = this.server.mkdirs(src, masked, createParent);
            return bl;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            DirectoryListing directoryListing = this.server.getListing(src, startAfter, needLocation);
            return directoryListing;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            SnapshottableDirectoryStatus[] snapshottableDirectoryStatusArray = this.server.getSnapshottableDirListing();
            return snapshottableDirectoryStatusArray;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewLease(String clientName) throws AccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.renewLease(clientName);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            boolean bl = this.server.recoverLease(src, clientName);
            return bl;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getStats() throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            long[] lArray = this.server.getStats();
            return lArray;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            DatanodeInfo[] datanodeInfoArray = this.server.getDatanodeReport(type);
            return datanodeInfoArray;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            DatanodeStorageReport[] datanodeStorageReportArray = this.server.getDatanodeStorageReport(type);
            return datanodeStorageReportArray;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPreferredBlockSize(String filename) throws IOException, UnresolvedLinkException {
        try {
            AuthorizationProvider.beginClientOp();
            long l = this.server.getPreferredBlockSize(filename);
            return l;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            boolean bl = this.server.setSafeMode(action, isChecked);
            return bl;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveNamespace() throws AccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.saveNamespace();
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rollEdits() throws AccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            long l = this.server.rollEdits();
            return l;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restoreFailedStorage(String arg) throws AccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            boolean bl = this.server.restoreFailedStorage(arg);
            return bl;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshNodes() throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.refreshNodes();
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeUpgrade() throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.finalizeUpgrade();
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            RollingUpgradeInfo rollingUpgradeInfo = this.server.rollingUpgrade(action);
            return rollingUpgradeInfo;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            CorruptFileBlocks corruptFileBlocks = this.server.listCorruptFileBlocks(path, cookie);
            return corruptFileBlocks;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void metaSave(String filename) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.metaSave(filename);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.setBalancerBandwidth(bandwidth);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HdfsFileStatus getFileInfo(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            HdfsFileStatus hdfsFileStatus = this.server.getFileInfo(src);
            return hdfsFileStatus;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFileClosed(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            boolean bl = this.server.isFileClosed(src);
            return bl;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws AccessControlException, UnresolvedLinkException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            HdfsFileStatus hdfsFileStatus = this.server.getFileLinkInfo(src);
            return hdfsFileStatus;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentSummary getContentSummary(String path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            ContentSummary contentSummary = this.server.getContentSummary(path);
            return contentSummary;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQuota(String path, long namespaceQuota, long diskspaceQuota) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.setQuota(path, namespaceQuota, diskspaceQuota);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fsync(String src, long inodeId, String client, long lastBlockLength) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.fsync(src, inodeId, client, lastBlockLength);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimes(String src, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.setTimes(src, mtime, atime);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSymlink(String target, String link, FsPermission dirPerm, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, SnapshotAccessControlException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.createSymlink(target, link, dirPerm, createParent);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLinkTarget(String path) throws AccessControlException, FileNotFoundException, IOException {
        try {
            AuthorizationProvider.beginClientOp();
            String string = this.server.getLinkTarget(path);
            return string;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            LocatedBlock locatedBlock = this.server.updateBlockForPipeline(block, clientName);
            return locatedBlock;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.updatePipeline(clientName, oldBlock, newBlock, newNodes, newStorageIDs);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            Token<DelegationTokenIdentifier> token = this.server.getDelegationToken(renewer);
            return token;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            long l = this.server.renewDelegationToken(token);
            return l;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.cancelDelegationToken(token);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            DataEncryptionKey dataEncryptionKey = this.server.getDataEncryptionKey();
            return dataEncryptionKey;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            String string = this.server.createSnapshot(snapshotRoot, snapshotName);
            return string;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.deleteSnapshot(snapshotRoot, snapshotName);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameSnapshot(String snapshotRoot, String snapshotOldName, String snapshotNewName) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.renameSnapshot(snapshotRoot, snapshotOldName, snapshotNewName);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allowSnapshot(String snapshotRoot) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.allowSnapshot(snapshotRoot);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disallowSnapshot(String snapshotRoot) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.disallowSnapshot(snapshotRoot);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String fromSnapshot, String toSnapshot) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            SnapshotDiffReport snapshotDiffReport = this.server.getSnapshotDiffReport(snapshotRoot, fromSnapshot, toSnapshot);
            return snapshotDiffReport;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            long l = this.server.addCacheDirective(directive, flags);
            return l;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.modifyCacheDirective(directive, flags);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCacheDirective(long id) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.removeCacheDirective(id);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> batchedEntries = this.server.listCacheDirectives(prevId, filter);
            return batchedEntries;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCachePool(CachePoolInfo info) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.addCachePool(info);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyCachePool(CachePoolInfo req) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.modifyCachePool(req);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCachePool(String pool) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.removeCachePool(pool);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevPool) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            BatchedRemoteIterator.BatchedEntries<CachePoolEntry> batchedEntries = this.server.listCachePools(prevPool);
            return batchedEntries;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.modifyAclEntries(src, aclSpec);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.removeAclEntries(src, aclSpec);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDefaultAcl(String src) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.removeDefaultAcl(src);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAcl(String src) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.removeAcl(src);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.setAcl(src, aclSpec);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AclStatus getAclStatus(String src) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            AclStatus aclStatus = this.server.getAclStatus(src);
            return aclStatus;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createEncryptionZone(String src, String keyName) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.createEncryptionZone(src, keyName);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EncryptionZone getEZForPath(String src) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            EncryptionZone encryptionZone = this.server.getEZForPath(src);
            return encryptionZone;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            BatchedRemoteIterator.BatchedEntries<EncryptionZone> batchedEntries = this.server.listEncryptionZones(prevId);
            return batchedEntries;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.setXAttr(src, xAttr, flag);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            List<XAttr> list = this.server.getXAttrs(src, xAttrs);
            return list;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<XAttr> listXAttrs(String src) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            List<XAttr> list = this.server.listXAttrs(src);
            return list;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.removeXAttr(src, xAttr);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkAccess(String path, FsAction mode) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            this.server.checkAccess(path, mode);
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentEditLogTxid() throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            long l = this.server.getCurrentEditLogTxid();
            return l;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventBatchList getEditsFromTxid(long txid) throws IOException {
        try {
            AuthorizationProvider.beginClientOp();
            EventBatchList eventBatchList = this.server.getEditsFromTxid(txid);
            return eventBatchList;
        }
        finally {
            AuthorizationProvider.endClientOp();
        }
    }
}

