/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ImplementsMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.ViewImpl;

public class RDBMSStoreData
extends StoreData {
    public RDBMSStoreData(String name, String tableName, boolean tableOwner, int type, String interfaceName) {
        super(name, null, type, interfaceName);
        this.addProperty("table", tableName);
        this.addProperty("table-owner", tableOwner ? "true" : "false");
    }

    public RDBMSStoreData(ClassMetaData cmd, Table table, boolean tableOwner) {
        super(cmd.getFullClassName(), (MetaData)cmd, 1, null);
        this.addProperty("table", table != null ? table.toString() : null);
        this.addProperty("table-owner", tableOwner ? "true" : "false");
        if (table != null) {
            this.addProperty("tableObject", table);
            this.addProperty("tableId", table.getIdentifier());
        }
        String interfaces = null;
        ImplementsMetaData[] implMds = cmd.getImplementsMetaData();
        if (implMds != null) {
            for (int i = 0; i < cmd.getImplementsMetaData().length; ++i) {
                interfaces = interfaces == null ? "" : interfaces + ",";
                interfaces = interfaces + cmd.getImplementsMetaData()[i].getName();
            }
            this.addProperty("interface-name", interfaces);
        }
    }

    public RDBMSStoreData(AbstractMemberMetaData mmd, Table table) {
        super(mmd.getFullFieldName(), (MetaData)mmd, 2, null);
        String interfaceName;
        if (table == null) {
            throw new NullPointerException("table should not be null");
        }
        this.addProperty("table", table.toString());
        this.addProperty("table-owner", "true");
        this.addProperty("tableObject", table);
        this.addProperty("tableId", table.getIdentifier());
        String string = interfaceName = table.getStoreManager().getMetaDataManager().isPersistentInterface(mmd.getType().getName()) ? mmd.getType().getName() : null;
        if (interfaceName != null) {
            this.addProperty("interface-name", interfaceName);
        }
    }

    public boolean mapsToView() {
        Table table = this.getTable();
        if (table == null) {
            return false;
        }
        return table instanceof ViewImpl;
    }

    public String getTableName() {
        return (String)this.properties.get("table");
    }

    public boolean isTableOwner() {
        return ((String)this.properties.get("table-owner")).equals("true");
    }

    public boolean hasTable() {
        return this.properties.get("table") != null;
    }

    public Table getTable() {
        return (Table)this.properties.get("tableObject");
    }

    public DatastoreIdentifier getDatastoreIdentifier() {
        return (DatastoreIdentifier)this.properties.get("tableId");
    }

    public void setDatastoreContainerObject(DatastoreClass table) {
        if (table != null) {
            this.addProperty("table", table.toString());
            this.addProperty("tableObject", table);
            this.addProperty("tableId", table.getIdentifier());
        }
    }

    public String toString() {
        String tableName = (String)this.properties.get("table");
        MetaData metadata = this.getMetaData();
        if (metadata instanceof ClassMetaData) {
            ClassMetaData cmd = (ClassMetaData)metadata;
            return LOCALISER.msg("035004", (Object)this.name, (Object)(tableName != null ? tableName : "(none)"), (Object)cmd.getInheritanceMetaData().getStrategy().toString());
        }
        if (metadata instanceof AbstractMemberMetaData) {
            return LOCALISER.msg("035005", (Object)this.name, (Object)tableName);
        }
        return LOCALISER.msg("035004", (Object)this.name, (Object)tableName);
    }
}

