/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class BooleanRDBMSMapping
extends AbstractDatastoreMapping {
    public BooleanRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    @Override
    public boolean isBooleanBased() {
        return true;
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(16, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(16);
    }

    @Override
    public void setBoolean(PreparedStatement ps, int param, boolean value) {
        try {
            ps.setBoolean(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"boolean", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public boolean getBoolean(ResultSet rs, int param) {
        boolean value;
        try {
            value = rs.getBoolean(param);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Boolean", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setString(PreparedStatement ps, int param, String value) {
        try {
            if (value == null) {
                ps.setNull(param, this.getTypeInfo().getDataType());
            } else {
                ps.setBoolean(param, value.equals("Y"));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public String getString(ResultSet rs, int param) {
        String value;
        try {
            value = rs.getBoolean(param) ? "Y" : "N";
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"String", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        block5: {
            try {
                if (value == null) {
                    ps.setNull(param, this.getTypeInfo().getDataType());
                    break block5;
                }
                if (value instanceof String) {
                    ps.setBoolean(param, value.equals("Y"));
                    break block5;
                }
                if (value instanceof Boolean) {
                    ps.setBoolean(param, (Boolean)value);
                    break block5;
                }
                throw new NucleusUserException(LOCALISER_RDBMS.msg("055004", value, (Object)this.column));
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Object value;
        try {
            boolean b = rs.getBoolean(param);
            value = rs.wasNull() ? null : (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_STRING) ? (b ? "Y" : "N") : (b ? Boolean.TRUE : Boolean.FALSE));
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

