/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.CSVSchemaCommand;
import org.kitesdk.cli.commands.CopyCommand;
import org.kitesdk.data.DatasetRepositories;
import org.kitesdk.data.DatasetRepository;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestCopyCommandLocal {
    private static final String source = "users_source";
    private static final String dest = "users_dest";
    private static final String avsc = "target/user.avsc";
    private Logger console;
    private CopyCommand command;

    @BeforeClass
    public static void createSourceDataset() throws Exception {
        TestUtil.run("delete", source, "--use-local", "-d", "target/data");
        String csv = "target/users.csv";
        BufferedWriter writer = Files.newWriter((File)new File(csv), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        writer.append("1,test,test@example.com\n");
        writer.append("2,user,user@example.com\n");
        writer.close();
        TestUtil.run("-v", "csv-schema", csv, "-o", avsc, "--class", "User");
        TestUtil.run("create", source, "-s", avsc, "--use-local", "-d", "target/data");
        TestUtil.run("csv-import", csv, source, "--use-local", "-d", "target/data");
    }

    @AfterClass
    public static void deleteSourceDataset() throws Exception {
        TestUtil.run("delete", source, "--use-local", "-d", "target/data");
    }

    @Before
    public void createDestination() throws Exception {
        TestUtil.run("delete", dest, "--use-local", "-d", "target/data");
        TestUtil.run("create", dest, "-s", avsc, "--use-local", "-d", "target/data");
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new CopyCommand(this.console);
        this.command.setConf(new Configuration());
    }

    @After
    public void deleteDestination() throws Exception {
        TestUtil.run("delete", dest, "--use-local", "-d", "target/data");
    }

    @Test
    public void testBasicCopy() throws Exception {
        this.command.repoURI = "file:target/data";
        this.command.datasets = Lists.newArrayList((Object[])new String[]{source, dest});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        DatasetRepository repo = DatasetRepositories.open((String)"repo:file:target/data");
        int size = DatasetTestUtilities.datasetSize((View)repo.load(source));
        Assert.assertEquals((String)"Should contain copied records", (long)2L, (long)size);
    }
}

