/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.cli.commands.CreateDatasetCommand;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetRepository;
import org.kitesdk.data.MockRepositories;
import org.kitesdk.data.TestHelpers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestCreateDatasetCommand {
    private DatasetRepository repo;
    private CreateDatasetCommand command = null;
    private Logger console;

    @Before
    public void setUp() {
        this.repo = MockRepositories.newMockRepository();
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new CreateDatasetCommand(this.console);
        this.command.setConf(new Configuration());
        this.command.repoURI = this.repo.getUri().toString();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).getUri();
    }

    @Test
    public void testBasicUse() throws Exception {
        this.command.avroSchemaFile = "resource:test-schemas/user.avsc";
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.run();
        DatasetDescriptor expectedDescriptor = new DatasetDescriptor.Builder().schemaUri("resource:test-schemas/user.avsc").build();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).create("users", expectedDescriptor);
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Created"), Mockito.eq((Object)"users"));
    }

    @Test
    public void testParquetFormat() throws Exception {
        this.command.avroSchemaFile = "resource:test-schemas/user.avsc";
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.format = "parquet";
        this.command.run();
        DatasetDescriptor expectedDescriptor = new DatasetDescriptor.Builder().schemaUri("resource:test-schemas/user.avsc").format("parquet").build();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).create("users", expectedDescriptor);
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Created"), Mockito.eq((Object)"users"));
    }

    @Test
    public void testUnrecognizedFormat() throws Exception {
        this.command.avroSchemaFile = "resource:test-schemas/user.avsc";
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.format = "nosuchformat";
        TestHelpers.assertThrows((String)"Should fail on invalid format", IllegalArgumentException.class, (Callable)new Callable(){

            public Void call() throws Exception {
                TestCreateDatasetCommand.this.command.run();
                return null;
            }
        });
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testNonExistentAvroSchemaFile() throws Exception {
        this.command.avroSchemaFile = "nonexistent.avsc";
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        TestHelpers.assertThrows((String)"Should fail on missing schema", FileNotFoundException.class, (Callable)new Callable(){

            public Void call() throws Exception {
                TestCreateDatasetCommand.this.command.run();
                return null;
            }
        });
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMultipleDatasets() throws Exception {
        this.command.avroSchemaFile = "test-schemas/user.avsc";
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users", "moreusers"});
        TestHelpers.assertThrows((String)"Should reject multiple dataset names", IllegalArgumentException.class, (Callable)new Callable(){

            public Void call() throws Exception {
                TestCreateDatasetCommand.this.command.run();
                return null;
            }
        });
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.console});
    }
}

