/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.cli.commands.DeleteDatasetCommand;
import org.kitesdk.data.DatasetRepository;
import org.kitesdk.data.MockRepositories;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestDeleteDatasetCommand {
    private DatasetRepository repo;
    private DeleteDatasetCommand command;
    private Logger console;

    @Before
    public void setUp() {
        this.repo = MockRepositories.newMockRepository();
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new DeleteDatasetCommand(this.console);
        this.command.repoURI = this.repo.getUri().toString();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).getUri();
    }

    @Test
    public void testBasicUse() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.run();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).delete("users");
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Deleted"), Mockito.eq((Object)"users"));
    }

    @Test
    public void testMultipleDatasets() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users", "moreusers"});
        this.command.run();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).delete("users");
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Deleted"), Mockito.eq((Object)"users"));
        ((DatasetRepository)Mockito.verify((Object)this.repo)).delete("moreusers");
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Deleted"), Mockito.eq((Object)"moreusers"));
    }
}

