/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.UpdateDatasetCommand;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.MockRepositories;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.spi.DatasetRepository;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestUpdateDatasetCommand {
    private DatasetRepository repo;
    private Dataset<Object> ds;
    private UpdateDatasetCommand command;
    private Logger console;
    private DatasetDescriptor original;
    String schema1 = "{\"type\": \"record\", \"name\": \"Record\",   \"fields\": [    { \"name\": \"f0\", \"type\": \"string\" }  ]}";
    String schema2 = "{\"type\": \"record\", \"name\": \"Record\",   \"fields\": [    { \"name\": \"f0\", \"type\": \"string\" },    { \"name\": \"f1\", \"type\": \"int\" }  ]}";

    @Before
    public void setUp() {
        this.repo = MockRepositories.newMockRepository();
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new UpdateDatasetCommand(this.console);
        this.command.repoURI = this.repo.getUri().toString();
        this.command.setConf(new Configuration());
        ((DatasetRepository)Mockito.verify((Object)this.repo)).getUri();
        this.original = new DatasetDescriptor.Builder().schemaLiteral(this.schema1).property("should.be.present", "true").build();
        this.ds = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.load("users")).thenReturn(this.ds);
        Mockito.when((Object)this.ds.getDataset()).thenReturn(this.ds);
        Mockito.when((Object)this.ds.getDescriptor()).thenReturn((Object)this.original);
    }

    @Test
    public void testBasicUse() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.run();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("users");
        ((Dataset)Mockito.verify(this.ds)).getDescriptor();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).update((String)Mockito.eq((Object)"users"), (DatasetDescriptor)Mockito.argThat(TestUtil.matches(this.original)));
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Updated"), Mockito.eq((Object)"users"));
    }

    @Test
    public void testUpdateSchema() throws Exception {
        File avroSchemaFile = new File("target/schema_update.avsc");
        new FileWriter(avroSchemaFile).append(this.schema2).close();
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.avroSchemaFile = avroSchemaFile.toString();
        this.command.run();
        DatasetDescriptor updated = new DatasetDescriptor.Builder(this.original).schemaLiteral(this.schema2).build();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("users");
        ((Dataset)Mockito.verify(this.ds)).getDescriptor();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).update((String)Mockito.eq((Object)"users"), (DatasetDescriptor)Mockito.argThat(TestUtil.matches(updated)));
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Updated"), Mockito.eq((Object)"users"));
    }

    @Test
    public void testAddProperty() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.properties = Lists.newArrayList((Object[])new String[]{"new.property=1234", "prop=with=equals"});
        this.command.run();
        DatasetDescriptor updated = new DatasetDescriptor.Builder(this.original).property("new.property", "1234").property("prop", "with=equals").build();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("users");
        ((Dataset)Mockito.verify(this.ds)).getDescriptor();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).update((String)Mockito.eq((Object)"users"), (DatasetDescriptor)Mockito.argThat(TestUtil.matches(updated)));
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Updated"), Mockito.eq((Object)"users"));
    }

    @Test
    public void testZeroDatasets() throws Exception {
        this.command.datasets = Lists.newArrayList();
        TestHelpers.assertThrows((String)"Should require one dataset", IllegalArgumentException.class, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                TestUpdateDatasetCommand.this.command.run();
                return null;
            }
        });
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMultipleDatasets() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users", "moreusers"});
        TestHelpers.assertThrows((String)"Should reject multiple datasets", IllegalArgumentException.class, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                TestUpdateDatasetCommand.this.command.run();
                return null;
            }
        });
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testNonExistentAvroSchemaFile() throws Exception {
        this.command.avroSchemaFile = "nonexistent.avsc";
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        TestHelpers.assertThrows((String)"Should fail on missing schema", FileNotFoundException.class, (Callable)new Callable(){

            public Void call() throws Exception {
                TestUpdateDatasetCommand.this.command.run();
                return null;
            }
        });
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.console});
    }
}

