/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.cli.Command;
import org.kitesdk.cli.Main;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class TestMain {
    private Logger console;
    private Main main;

    @Before
    public void initializeMain() {
        this.console = (Logger)Mockito.mock(Logger.class);
        this.main = new Main(this.console);
        TestCommand test = new TestCommand();
        this.main.jc.addCommand("test", (Object)test);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testNoArgs() throws Exception {
        int rc = this.run(new String[0]);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Usage: {} [options] [command] [command options]"), Mockito.eq((Object)"kite-dataset"));
        Assert.assertEquals((long)1L, (long)rc);
    }

    @Test
    public void testUnrecognizedCommand() throws Exception {
        int rc = this.run("unrecognizedcommand");
        ((Logger)Mockito.verify((Object)this.console)).error(Mockito.startsWith((String)"Expected a command, got unrecognizedcommand"));
        Assert.assertEquals((long)1L, (long)rc);
    }

    @Test
    public void testHelp() throws Exception {
        int rc = this.run("help");
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Usage: {} [options] [command] [command options]"), Mockito.eq((Object)"kite-dataset"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Options"));
        ((Logger)Mockito.verify((Object)this.console, (VerificationMode)Mockito.times((int)2))).info(Mockito.anyString(), (Object[])Mockito.any(Object[].class));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Commands"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), Mockito.eq((Object)"create"), (Object)Mockito.anyString());
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), Mockito.eq((Object)"delete"), (Object)Mockito.anyString());
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), Mockito.eq((Object)"help"), (Object)Mockito.anyString());
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), Mockito.eq((Object)"schema"), (Object)Mockito.anyString());
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), Mockito.eq((Object)"csv-schema"), (Object)Mockito.anyString());
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), Mockito.eq((Object)"test"), Mockito.eq((Object)"Test description"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Examples"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"{} help create"), Mockito.eq((Object)"kite-dataset"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"See '{} help <command>' for more information"), Mockito.eq((Object)"kite-dataset"));
        Assert.assertEquals((long)0L, (long)rc);
    }

    @Test
    public void testHelpCommand() throws Exception {
        int rc = this.run("help", "test");
        ((Logger)Mockito.verify((Object)this.console)).info("\nUsage: {} [general options] {} {} [command options]", new Object[]{"kite-dataset", "test", "<test dataset names>"});
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Description"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), (Object)Mockito.contains((String)"Test description"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Command options"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Examples"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), (Object)Mockito.contains((String)"# this is a comment"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), (Object[])Mockito.eq((Object)new Object[]{"kite-dataset", "test", "test dataset-name"}));
        Assert.assertEquals((long)0L, (long)rc);
    }

    @Test
    public void testCommandHelp() throws Exception {
        int rc = this.run("test", "--help");
        ((Logger)Mockito.verify((Object)this.console)).info("\nUsage: {} [general options] {} {} [command options]", new Object[]{"kite-dataset", "test", "<test dataset names>"});
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Description"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), (Object)Mockito.contains((String)"Test description"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Command options"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Examples"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), (Object)Mockito.contains((String)"this is a comment"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), (Object[])Mockito.eq((Object)new Object[]{"kite-dataset", "test", "test dataset-name"}));
        Assert.assertEquals((long)0L, (long)rc);
    }

    @Test
    public void testCommandHelpWithDollarZero() throws Exception {
        int rc = this.run("--dollar-zero", "datasets", "test", "--help");
        ((Logger)Mockito.verify((Object)this.console)).info("\nUsage: {} [general options] {} {} [command options]", new Object[]{"datasets", "test", "<test dataset names>"});
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Description"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), (Object)Mockito.contains((String)"Test description"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Command options"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Examples"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), (Object)Mockito.contains((String)"this is a comment"));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), (Object[])Mockito.eq((Object)new Object[]{"datasets", "test", "test dataset-name"}));
        Assert.assertEquals((long)0L, (long)rc);
    }

    @Test
    public void testVersion() throws Exception {
        int rc = this.run("--version");
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.contains((String)"Kite version"), (Object)Mockito.anyString());
        Assert.assertEquals((long)0L, (long)rc);
    }

    @Test
    public void testUnknownCommand() throws Exception {
        int rc = this.run("help", "unknown");
        ((Logger)Mockito.verify((Object)this.console)).error(Mockito.contains((String)"Unknown command"), Mockito.eq((Object)"unknown"));
        Assert.assertEquals((long)1L, (long)rc);
    }

    @Test
    public void testIllegalArguments() throws Exception {
        int rc = this.run("test", "--throw-arg");
        ((Logger)Mockito.verify((Object)this.console)).error(Mockito.startsWith((String)"Argument error"), Mockito.eq((Object)"--throw-arg was set"));
        Assert.assertEquals((long)1L, (long)rc);
    }

    @Test
    public void testIllegalState() throws Exception {
        int rc = this.run("test", "--throw-state");
        ((Logger)Mockito.verify((Object)this.console)).error(Mockito.startsWith((String)"State error"), Mockito.eq((Object)"--throw-state was set"));
        Assert.assertEquals((long)1L, (long)rc);
    }

    @Test
    public void testUnexpectedException() throws Exception {
        int rc = this.run("test", "--throw-unknown");
        ((Logger)Mockito.verify((Object)this.console)).error(Mockito.startsWith((String)"Unknown error"), Mockito.eq((Object)"--throw-unknown was set"));
        Assert.assertEquals((long)1L, (long)rc);
    }

    @Test
    public void testUnexpectedExceptionWithDebug() throws Exception {
        int rc = this.run("--debug", "test", "--throw-unknown");
        ((Logger)Mockito.verify((Object)this.console)).error(Mockito.startsWith((String)"Unknown error"), (Throwable)Mockito.isA(SomeException.class));
        Assert.assertEquals((long)1L, (long)rc);
    }

    private int run(String ... args) throws Exception {
        return this.main.run(args);
    }

    @Parameters(commandDescription="Test description")
    static class TestCommand
    implements Command {
        @Parameter(description="<test dataset names>")
        List<String> datasets;
        @Parameter(names={"--throw-arg"}, description="Causes an IllegalArugmentException", hidden=true)
        boolean throwArg = false;
        @Parameter(names={"--throw-state"}, description="Causes an IllegalStateException", hidden=true)
        boolean throwState = false;
        @Parameter(names={"--throw-unknown"}, description="Causes an unknown exception", hidden=true)
        boolean throwUnknown = false;

        TestCommand() {
        }

        public int run() throws IOException {
            Preconditions.checkArgument((!this.throwArg ? 1 : 0) != 0, (Object)"--throw-arg was set");
            Preconditions.checkState((!this.throwState ? 1 : 0) != 0, (Object)"--throw-state was set");
            if (this.throwUnknown) {
                throw new SomeException("--throw-unknown was set");
            }
            return 0;
        }

        public List<String> getExamples() {
            return Lists.newArrayList((Object[])new String[]{"# this is a comment", "test dataset-name"});
        }
    }

    private static class SomeException
    extends RuntimeException {
        private SomeException(String message) {
            super(message);
        }
    }
}

