/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Sets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.CSVImportCommand;
import org.kitesdk.cli.commands.CSVSchemaCommand;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestCSVImportCommandCluster
extends MiniDFSTest {
    private static String sample;
    private static String avsc;
    private static String datasetName;
    private static String repoURI;
    private Logger console = null;
    private CSVImportCommand command;
    private Dataset<GenericData.Record> dataset;
    private static final Set<GenericData.Record> expected;

    @BeforeClass
    public static void createCSVSchemaAndSample() throws Exception {
        sample = "target/users.csv";
        avsc = "target/user.avsc";
        datasetName = "users";
        repoURI = "repo:" + TestCSVImportCommandCluster.getDFS().getUri().toString() + "/tmp/data";
        BufferedWriter writer = Files.newWriter((File)new File(sample), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        writer.append("1,test,test@example.com\n");
        writer.append("2,user,user@example.com\n");
        writer.close();
        TestUtil.run("csv-schema", sample, "-o", avsc, "--class", "User");
        GenericRecordBuilder builder = new GenericRecordBuilder(new Schema.Parser().parse(new File(avsc)));
        builder.set("id", (Object)1L);
        builder.set("username", (Object)"test");
        builder.set("email", (Object)"test@example.com");
        expected.add(builder.build());
        builder.set("id", (Object)2L);
        builder.set("username", (Object)"user");
        builder.set("email", (Object)"user@example.com");
        expected.add(builder.build());
    }

    @Before
    public void setup() throws Exception {
        TestUtil.run("create", datasetName, "-r", repoURI, "-s", avsc);
        this.dataset = (Dataset)Datasets.load((URI)URIBuilder.build((String)repoURI, (String)"default", (String)datasetName), GenericData.Record.class);
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new CSVImportCommand(this.console);
        this.command.setConf(new Configuration());
        this.command.repoURI = repoURI;
        Configuration conf = TestCSVImportCommandCluster.getConfiguration();
        conf.setBoolean("kite.testing", true);
        this.command.setConf(conf);
    }

    @After
    public void removeData() throws Exception {
        TestUtil.run("delete", datasetName, "-r", repoURI);
    }

    @Test
    public void testBasicImport() throws Exception {
        this.command.targets = Lists.newArrayList((Object[])new String[]{sample, datasetName});
        this.command.run();
        Assert.assertEquals((String)"Should contain expected records", expected, (Object)DatasetTestUtilities.materialize(this.dataset));
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)2L, (Object)datasetName);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testHDFSBasicImport() throws Exception {
        Path hdfsSample = TestCSVImportCommandCluster.getDFS().makeQualified(new Path("hdfs:/tmp/" + sample));
        TestCSVImportCommandCluster.getDFS().copyFromLocalFile(new Path(sample), hdfsSample);
        this.command.targets = Lists.newArrayList((Object[])new String[]{hdfsSample.toString(), datasetName});
        this.command.run();
        Assert.assertEquals((String)"Should contain expected records", expected, (Object)DatasetTestUtilities.materialize(this.dataset));
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)2L, (Object)datasetName);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testDirectoryImport() throws Exception {
        new File("target/sample").mkdir();
        BufferedWriter writer = Files.newWriter((File)new File("target/sample/one.csv"), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        writer.append("1,test,test@example.com\n");
        writer.close();
        writer = Files.newWriter((File)new File("target/sample/two.csv"), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        writer.append("2,user,user@example.com\n");
        writer.close();
        this.command.targets = Lists.newArrayList((Object[])new String[]{"target/sample", datasetName});
        this.command.run();
        Assert.assertEquals((String)"Should contain expected records", expected, (Object)DatasetTestUtilities.materialize(this.dataset));
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)2L, (Object)datasetName);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testHDFSDirectoryImport() throws Exception {
        Path hdfsSample = TestCSVImportCommandCluster.getDFS().makeQualified(new Path("hdfs:/tmp/sample"));
        TestCSVImportCommandCluster.getDFS().mkdirs(hdfsSample);
        FSDataOutputStream one = TestCSVImportCommandCluster.getDFS().create(new Path(hdfsSample, "one.csv"), true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)one, "utf8");
        writer.write("id,username,email\n");
        writer.write("1,test,test@example.com\n");
        writer.close();
        FSDataOutputStream two = TestCSVImportCommandCluster.getDFS().create(new Path(hdfsSample, "two.csv"), true);
        writer = new OutputStreamWriter((OutputStream)two, "utf8");
        writer.append("id,username,email\n");
        writer.append("2,user,user@example.com\n");
        writer.close();
        this.command.targets = Lists.newArrayList((Object[])new String[]{hdfsSample.toString(), datasetName});
        this.command.run();
        Assert.assertEquals((String)"Should contain expected records", expected, (Object)DatasetTestUtilities.materialize(this.dataset));
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)2L, (Object)datasetName);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testEmptyHDFSSampleDirectory() throws Exception {
        String hdfsSample = "hdfs:/tmp/emptyDir";
        TestCSVImportCommandCluster.getDFS().mkdirs(new Path(hdfsSample));
        this.command.targets = Lists.newArrayList((Object[])new String[]{hdfsSample, datasetName});
        TestHelpers.assertThrows((String)"Should complain about no data files", IllegalArgumentException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCSVImportCommandCluster.this.command.run();
                return null;
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    static {
        expected = Sets.newHashSet();
    }
}

