/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.apache.log4j.PropertyConfigurator;
import org.kitesdk.cli.Command;
import org.kitesdk.cli.Help;
import org.kitesdk.cli.commands.CSVImportCommand;
import org.kitesdk.cli.commands.CSVSchemaCommand;
import org.kitesdk.cli.commands.CopyCommand;
import org.kitesdk.cli.commands.CreateColumnMappingCommand;
import org.kitesdk.cli.commands.CreateDatasetCommand;
import org.kitesdk.cli.commands.CreatePartitionStrategyCommand;
import org.kitesdk.cli.commands.DeleteDatasetCommand;
import org.kitesdk.cli.commands.FlumeConfigCommand;
import org.kitesdk.cli.commands.InfoCommand;
import org.kitesdk.cli.commands.Log4jConfigCommand;
import org.kitesdk.cli.commands.ObjectSchemaCommand;
import org.kitesdk.cli.commands.SchemaCommand;
import org.kitesdk.cli.commands.ShowRecordsCommand;
import org.kitesdk.cli.commands.TransformCommand;
import org.kitesdk.cli.commands.UpdateDatasetCommand;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Kite dataset management utility")
public class Main
extends Configured
implements Tool {
    @Parameter(names={"-v", "--verbose", "--debug"}, description="Print extra debugging information")
    private boolean debug = false;
    @Parameter(names={"--version"}, description="Print Kite version and exit")
    private boolean printVersion = false;
    @Parameter(names={"--dollar-zero"}, description="A way for the runtime path to be passed in", hidden=true)
    @VisibleForTesting
    String programName = "kite-dataset";
    @VisibleForTesting
    static final String DEFAULT_PROGRAM_NAME = "kite-dataset";
    private static Set<String> HELP_ARGS = ImmutableSet.of((Object)"-h", (Object)"-help", (Object)"--help", (Object)"help");
    private final Logger console;
    private final Help help;
    @VisibleForTesting
    final JCommander jc;

    Main(Logger console) {
        this.console = console;
        this.jc = new JCommander((Object)this);
        this.help = new Help(this.jc, console);
        this.jc.setProgramName(DEFAULT_PROGRAM_NAME);
        this.jc.addCommand("help", (Object)this.help, new String[]{"-h", "-help", "--help"});
        this.jc.addCommand("create", (Object)new CreateDatasetCommand(console));
        this.jc.addCommand("copy", (Object)new CopyCommand(console));
        this.jc.addCommand("transform", (Object)new TransformCommand(console));
        this.jc.addCommand("update", (Object)new UpdateDatasetCommand(console));
        this.jc.addCommand("delete", (Object)new DeleteDatasetCommand(console));
        this.jc.addCommand("schema", (Object)new SchemaCommand(console));
        this.jc.addCommand("info", (Object)new InfoCommand(console));
        this.jc.addCommand("show", (Object)new ShowRecordsCommand(console));
        this.jc.addCommand("csv-schema", (Object)new CSVSchemaCommand(console));
        this.jc.addCommand("csv-import", (Object)new CSVImportCommand(console));
        this.jc.addCommand("obj-schema", (Object)new ObjectSchemaCommand(console));
        this.jc.addCommand("partition-config", (Object)new CreatePartitionStrategyCommand(console));
        this.jc.addCommand("mapping-config", (Object)new CreateColumnMappingCommand(console));
        this.jc.addCommand("log4j-config", (Object)new Log4jConfigCommand(console));
        this.jc.addCommand("flume-config", (Object)new FlumeConfigCommand(console));
    }

    public int run(String[] args) throws Exception {
        String parsed;
        try {
            this.jc.parse(args);
        }
        catch (MissingCommandException e) {
            this.console.error(e.getMessage());
            return 1;
        }
        catch (ParameterException e) {
            this.help.setProgramName(this.programName);
            String cmd = this.jc.getParsedCommand();
            if (args.length == 1) {
                this.help.helpCommands.add(cmd);
                this.help.run();
                return 1;
            }
            for (String arg : args) {
                if (!HELP_ARGS.contains(arg)) continue;
                this.help.helpCommands.add(cmd);
                this.help.run();
                return 0;
            }
            this.console.error(e.getMessage());
            return 1;
        }
        this.help.setProgramName(this.programName);
        if (this.printVersion) {
            this.console.info("Kite version \"{}\"", (Object)this.getVersion());
            return 0;
        }
        if (this.debug) {
            org.apache.log4j.Logger console = org.apache.log4j.Logger.getLogger(Main.class);
            console.setLevel(Level.DEBUG);
        }
        if ((parsed = this.jc.getParsedCommand()) == null) {
            this.help.run();
            return 1;
        }
        if ("help".equals(parsed)) {
            return this.help.run();
        }
        Command command = (Command)((JCommander)this.jc.getCommands().get(parsed)).getObjects().get(0);
        if (command == null) {
            this.help.run();
            return 1;
        }
        try {
            if (command instanceof Configurable) {
                ((Configurable)command).setConf(this.getConf());
            }
            return command.run();
        }
        catch (IllegalArgumentException e) {
            if (this.debug) {
                this.console.error("Argument error", (Throwable)e);
            } else {
                this.console.error("Argument error: {}", (Object)e.getMessage());
            }
            return 1;
        }
        catch (IllegalStateException e) {
            if (this.debug) {
                this.console.error("State error", (Throwable)e);
            } else {
                this.console.error("State error: {}", (Object)e.getMessage());
            }
            return 1;
        }
        catch (ValidationException e) {
            if (this.debug) {
                this.console.error("Validation error", (Throwable)e);
            } else {
                this.console.error("Validation error: {}", (Object)e.getMessage());
            }
            return 1;
        }
        catch (DatasetNotFoundException e) {
            if (this.debug) {
                this.console.error("Cannot find dataset", (Throwable)e);
            } else {
                this.console.error(e.getMessage());
            }
            return 1;
        }
        catch (DatasetIOException e) {
            if (this.debug) {
                this.console.error("IO error", (Throwable)e);
            } else {
                this.console.error("IO error: {}", (Object)e.getMessage());
            }
            return 1;
        }
        catch (Exception e) {
            if (this.debug) {
                this.console.error("Unknown error", (Throwable)e);
            } else {
                this.console.error("Unknown error: {}", (Object)e.getMessage());
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        String location = "/META-INF/maven/org.kitesdk/kite-tools/pom.properties";
        String version = "unknown";
        InputStream pomPropertiesStream = null;
        try {
            Properties pomProperties = new Properties();
            pomPropertiesStream = Main.class.getResourceAsStream(location);
            pomProperties.load(pomPropertiesStream);
            version = pomProperties.getProperty("version");
        }
        catch (Exception ex) {
            block5: {
                try {
                    if (this.debug) {
                        this.console.warn("Unable to determine version from the {} file", (Object)location);
                        this.console.warn("Exception:", (Throwable)ex);
                        break block5;
                    }
                    this.console.warn("Unable to determine version from the {} file: {}", (Object)location, (Object)ex.getMessage());
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(pomPropertiesStream);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)pomPropertiesStream);
        }
        Closeables.closeQuietly((Closeable)pomPropertiesStream);
        return version;
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((URL)Main.class.getResource("/kite-cli-logging.properties"));
        Logger console = LoggerFactory.getLogger(Main.class);
        int rc = ToolRunner.run((Configuration)new Configuration(), (Tool)new Main(console), (String[])args);
        System.exit(rc);
    }
}

