/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Lists;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.kitesdk.cli.commands.BaseCommand;
import org.kitesdk.data.spi.filesystem.CSVProperties;
import org.kitesdk.data.spi.filesystem.CSVUtil;
import org.slf4j.Logger;

@Parameters(commandDescription="Build a schema from a CSV data sample")
public class CSVSchemaCommand
extends BaseCommand {
    @VisibleForTesting
    static final Charset SCHEMA_CHARSET = Charset.forName("utf8");
    private final Logger console;
    private Configuration conf;
    @Parameter(description="<sample csv path>")
    List<String> samplePaths;
    @Parameter(names={"-o", "--output"}, description="Save schema avsc to path")
    @SuppressWarnings(value={"UWF_NULL_FIELD"}, justification="Field set by JCommander")
    String outputPath = null;
    @Parameter(names={"--class", "--record-name"}, required=true, description="A name or class for the result schema")
    @SuppressWarnings(value={"UWF_NULL_FIELD"}, justification="Field set by JCommander")
    String recordName = null;
    @Parameter(names={"--minimize"}, description="Minimize schema file size by eliminating white space")
    boolean minimize = false;
    @Parameter(names={"--delimiter"}, description="Delimiter character")
    String delimiter = ",";
    @Parameter(names={"--escape"}, description="Escape character")
    String escape = "\\";
    @Parameter(names={"--quote"}, description="Quote character")
    String quote = "\"";
    @Parameter(names={"--no-header"}, description="Don't use first line as CSV header")
    boolean noHeader = false;
    @Parameter(names={"--skip-lines"}, description="Lines to skip before CSV start")
    int linesToSkip = 0;
    @Parameter(names={"--charset"}, description="Character set name", hidden=true)
    String charsetName = Charset.defaultCharset().displayName();

    public CSVSchemaCommand(Logger console) {
        this.console = console;
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.samplePaths != null && !this.samplePaths.isEmpty() ? 1 : 0) != 0, (Object)"Sample CSV path is required");
        Preconditions.checkArgument((this.samplePaths.size() == 1 ? 1 : 0) != 0, (Object)"Only one CSV sample can be given");
        CSVProperties props = new CSVProperties.Builder().delimiter(this.delimiter).escape(this.escape).quote(this.quote).hasHeader(!this.noHeader).linesToSkip(this.linesToSkip).charset(this.charsetName).build();
        String sampleSchema = CSVUtil.inferNullableSchema((String)this.recordName, (InputStream)this.open(this.samplePaths.get(0)), (CSVProperties)props).toString(!this.minimize);
        this.output(sampleSchema, this.console, this.outputPath);
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Print the schema for samples.csv to standard out:", "samples.csv --record-name Sample", "# Write schema to sample.avsc:", "samples.csv -o sample.avsc --record-name Sample"});
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }
}

