/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kitesdk.cli.commands.BaseCommand;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.ValidationException;
import org.slf4j.Logger;

@Parameters(commandDescription="Builds a partition strategy for a schema")
public class CreatePartitionStrategyCommand
extends BaseCommand {
    private static final Pattern PARTITION_FIELD = Pattern.compile("(\\w+):(\\w+)(?:\\[(\\d+)\\])?");
    private final Logger console;
    @Parameter(description="<field:type pairs>")
    List<String> partitions;
    @Parameter(names={"-s", "--schema"}, required=true, description="The file containing the Avro schema.")
    String avroSchemaFile;
    @Parameter(names={"--minimize"}, description="Minimize output size by eliminating white space")
    boolean minimize = false;
    @Parameter(names={"-o", "--output"}, description="Save schema avsc to path")
    @SuppressWarnings(value={"UWF_NULL_FIELD"}, justification="Field set by JCommander")
    String outputPath = null;

    public CreatePartitionStrategyCommand(Logger console) {
        this.console = console;
    }

    @Override
    public int run() throws IOException {
        PartitionStrategy.Builder strategyBuilder = new PartitionStrategy.Builder();
        for (String partition : this.partitions) {
            Matcher m = PARTITION_FIELD.matcher(partition);
            if (m.matches()) {
                String fieldName = m.group(1);
                ValidationException.check((fieldName != null && !fieldName.isEmpty() ? 1 : 0) != 0, (String)"Invalid field name: %s", (Object[])new Object[]{String.valueOf(fieldName)});
                if ("hash".equals(m.group(2))) {
                    String width = m.group(3);
                    ValidationException.check((width != null ? 1 : 0) != 0, (String)"Missing number of hash partitions: %s:hash[?]", (Object[])new Object[]{fieldName});
                    strategyBuilder.hash(fieldName, Integer.valueOf(width).intValue());
                    continue;
                }
                if ("copy".equals(m.group(2))) {
                    strategyBuilder.identity(fieldName);
                    continue;
                }
                if ("year".equals(m.group(2))) {
                    strategyBuilder.year(fieldName);
                    continue;
                }
                if ("month".equals(m.group(2))) {
                    strategyBuilder.month(fieldName);
                    continue;
                }
                if ("day".equals(m.group(2))) {
                    strategyBuilder.day(fieldName);
                    continue;
                }
                if ("hour".equals(m.group(2))) {
                    strategyBuilder.hour(fieldName);
                    continue;
                }
                if ("minute".equals(m.group(2))) {
                    strategyBuilder.minute(fieldName);
                    continue;
                }
                if ("provided".equals(m.group(2))) {
                    strategyBuilder.provided(fieldName);
                    continue;
                }
                throw new ValidationException("Unknown partitioner type: " + m.group(2));
            }
            throw new ValidationException("Invalid partition <field:type>: " + partition);
        }
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().partitionStrategy(strategyBuilder.build()).schema(this.open(this.avroSchemaFile)).build();
        String strategy = descriptor.getPartitionStrategy().toString(!this.minimize);
        this.output(strategy, this.console, this.outputPath);
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Partition by email address, balanced across 16 hash partitions", "email:hash[16] email:copy -s user.avsc -o email-part.json", "# Partition by created_at time's year, month, and day", "created_at:year created_at:month created_at:day -s event.avsc"});
    }
}

