/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.List;
import org.kitesdk.cli.commands.BaseCommand;
import org.kitesdk.data.DatasetDescriptor;
import org.slf4j.Logger;

@Parameters(commandDescription="Build a schema from a java class")
public class ObjectSchemaCommand
extends BaseCommand {
    private final Logger console;
    @Parameter(description="<class name>")
    List<String> classNames;
    @Parameter(names={"-o", "--output"}, description="Save schema avsc to path")
    @SuppressWarnings(value={"UWF_NULL_FIELD"}, justification="Field set by JCommander")
    String outputPath = null;
    @Parameter(names={"--minimize"}, description="Minimize schema file size by eliminating white space")
    boolean minimize = false;
    @Parameter(names={"--jar"}, description="Add a jar to the classpath used when loading the java class")
    List<String> jars;
    @Parameter(names={"--lib-dir"}, description="Add a directory to the classpath used when loading the java class")
    List<String> libs;

    public ObjectSchemaCommand(Logger console) {
        this.console = console;
    }

    @Override
    public int run() throws IOException {
        Class<?> recordClass;
        Preconditions.checkArgument((this.classNames != null && !this.classNames.isEmpty() ? 1 : 0) != 0, (Object)"Java class name is required");
        Preconditions.checkArgument((this.classNames.size() == 1 ? 1 : 0) != 0, (Object)"Only one java class name can be given");
        ClassLoader loader = ObjectSchemaCommand.loaderFor(this.jars, this.libs);
        String className = this.classNames.get(0);
        try {
            recordClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot find class: " + className, e);
        }
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(recordClass).build();
        String schema = descriptor.getSchema().toString(!this.minimize);
        this.output(schema, this.console, this.outputPath);
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Create a schema for an example User class:", "org.kitesdk.cli.example.User", "# Create a schema for a class in a jar:", "com.example.MyRecord --jar my-application.jar", "# Save the schema for the example User class to user.avsc:", "org.kitesdk.cli.example.User -o user.avsc"});
    }
}

