/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.crunch.MapFn;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.InputFormatImportCommand;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestInputFormatImportCommandCluster
extends MiniDFSTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static Configuration original;
    private static String datasetUri;
    private Logger console = null;
    private InputFormatImportCommand command;
    private static List<Measurement> measurements;

    @BeforeClass
    public static void replaceDefaultConfig() {
        original = DefaultConfiguration.get();
        DefaultConfiguration.set((Configuration)TestInputFormatImportCommandCluster.getConfiguration());
    }

    @AfterClass
    public static void restoreDefaultConfig() {
        DefaultConfiguration.set((Configuration)original);
    }

    @Before
    public void createTargetDataset() throws Exception {
        this.removeTargetDataset();
        String avsc = this.temp.newFile("schema.avsc").toString();
        TestUtil.run("obj-schema", Measurement.class.getName(), "-o", avsc);
        TestUtil.run("create", datasetUri, "-s", avsc);
    }

    @Before
    public void createCommand() {
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new InputFormatImportCommand(this.console);
        Configuration conf = TestInputFormatImportCommandCluster.getConfiguration();
        conf.setBoolean("kite.testing", true);
        this.command.setConf(conf);
    }

    @After
    public void removeTargetDataset() throws Exception {
        TestUtil.run("delete", datasetUri);
    }

    @Test
    public void testLocalImport() throws Exception {
        String sample = this.temp.newFile("sample.sequence").toString();
        TestInputFormatImportCommandCluster.writeSequenceFile(TestInputFormatImportCommandCluster.getFS(), new Path(sample));
        this.command.inFormatClass = CopyingInputFormat.class.getName();
        this.command.targets = Lists.newArrayList((Object[])new String[]{sample, datasetUri});
        this.command.noCompaction = true;
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)3L, (Object)datasetUri);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
        Set<Measurement> datasetContent = TestInputFormatImportCommandCluster.materialize((View<Measurement>)Datasets.load((String)datasetUri, Measurement.class));
        Assert.assertEquals((Object)Sets.newHashSet(measurements), datasetContent);
    }

    @Test
    public void testLocalImportWithTransform() throws Exception {
        String sample = this.temp.newFile("sample.sequence").toString();
        TestInputFormatImportCommandCluster.writeSequenceFile(TestInputFormatImportCommandCluster.getFS(), new Path(sample));
        this.command.inFormatClass = CopyingInputFormat.class.getName();
        this.command.targets = Lists.newArrayList((Object[])new String[]{sample, datasetUri});
        this.command.noCompaction = true;
        this.command.transform = TransformMeasurement.class.getName();
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)3L, (Object)datasetUri);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
        Set<Measurement> datasetContent = TestInputFormatImportCommandCluster.materialize((View<Measurement>)Datasets.load((String)datasetUri, Measurement.class));
        HashSet expected = Sets.newHashSet((Iterable)Iterables.transform(measurements, (Function)new TransformMeasurement()));
        Assert.assertEquals((Object)expected, datasetContent);
    }

    @Test
    public void testMRImport() throws Exception {
        Path sample = new Path(this.temp.newFile("sample.sequence").toString()).makeQualified(TestInputFormatImportCommandCluster.getDFS().getUri(), new Path("/"));
        TestInputFormatImportCommandCluster.writeSequenceFile(TestInputFormatImportCommandCluster.getDFS(), sample);
        this.command.inFormatClass = SequenceFileInputFormat.class.getName();
        this.command.targets = Lists.newArrayList((Object[])new String[]{sample.toString(), datasetUri});
        this.command.noCompaction = true;
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)3L, (Object)datasetUri);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
        Set<Measurement> datasetContent = TestInputFormatImportCommandCluster.materialize((View<Measurement>)Datasets.load((String)datasetUri, Measurement.class));
        Assert.assertEquals((Object)Sets.newHashSet(measurements), datasetContent);
    }

    @Test
    public void testMRImportWithTransform() throws Exception {
        Path sample = new Path(this.temp.newFile("sample.sequence").toString()).makeQualified(TestInputFormatImportCommandCluster.getDFS().getUri(), new Path("/"));
        TestInputFormatImportCommandCluster.writeSequenceFile(TestInputFormatImportCommandCluster.getDFS(), sample);
        this.command.inFormatClass = SequenceFileInputFormat.class.getName();
        this.command.targets = Lists.newArrayList((Object[])new String[]{sample.toString(), datasetUri});
        this.command.noCompaction = true;
        this.command.transform = TransformMeasurement.class.getName();
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)3L, (Object)datasetUri);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
        Set<Measurement> datasetContent = TestInputFormatImportCommandCluster.materialize((View<Measurement>)Datasets.load((String)datasetUri, Measurement.class));
        HashSet expected = Sets.newHashSet((Iterable)Iterables.transform(measurements, (Function)new TransformMeasurement()));
        Assert.assertEquals((Object)expected, datasetContent);
    }

    private static void writeSequenceFile(FileSystem fs, Path path) throws Exception {
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)TestInputFormatImportCommandCluster.getConfiguration(), (Path)path, Text.class, Measurement.class);
        for (Measurement m : measurements) {
            writer.append((Writable)new Text(m.name), (Writable)m);
        }
        writer.close();
    }

    private static Set<Measurement> materialize(View<Measurement> view) {
        HashSet measurements = Sets.newHashSet();
        for (Measurement m : view.newReader()) {
            measurements.add(new Measurement(m));
        }
        return measurements;
    }

    static {
        datasetUri = "dataset:hdfs:/tmp/datasets/sequence";
        measurements = Lists.newArrayList((Object[])new Measurement[]{new Measurement("temp", 32.0), new Measurement("speed", 88.0), new Measurement("length", 6.0)});
    }

    public static class Measurement
    implements Writable {
        private String name;
        private double value;

        public Measurement() {
        }

        public Measurement(Measurement toCopy) {
            this.name = toCopy.name;
            this.value = toCopy.value;
        }

        public Measurement(String name, double value) {
            this.name = name;
            this.value = value;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.name.length());
            out.write(Charsets.UTF_8.encode(this.name).array());
            out.writeDouble(this.value);
        }

        public void readFields(DataInput in) throws IOException {
            int length = in.readInt();
            byte[] nameBytes = new byte[length];
            in.readFully(nameBytes);
            this.name = Charsets.UTF_8.decode(ByteBuffer.wrap(nameBytes)).toString();
            this.value = in.readDouble();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Measurement that = (Measurement)o;
            return Objects.equal((Object)this.name, (Object)that.name) && Double.compare(this.value, that.value) == 0;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.value});
        }
    }

    public static class CopyingInputFormat
    extends SequenceFileInputFormat<Text, Measurement> {
        public RecordReader<Text, Measurement> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return new CopyingRecordReader();
        }

        public static class CopyingRecordReader
        extends SequenceFileRecordReader<Text, Measurement> {
            public Text getCurrentKey() {
                return new Text((Text)super.getCurrentKey());
            }

            public Measurement getCurrentValue() {
                return new Measurement((Measurement)super.getCurrentValue());
            }
        }
    }

    public static class TransformMeasurement
    extends MapFn<Measurement, Measurement>
    implements Function<Measurement, Measurement> {
        public Measurement map(Measurement m) {
            return this.apply(m);
        }

        public Measurement apply(Measurement m) {
            m.value += 3.0;
            return m;
        }
    }
}

