/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.BaseCommand;
import org.kitesdk.cli.commands.SchemaCommand;
import org.kitesdk.data.TestHelpers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestSchemaCommand {
    private static Schema schema = null;
    private Logger console = null;
    private SchemaCommand command;

    @BeforeClass
    public static void parseUserSchema() throws Exception {
        schema = new Schema.Parser().parse(Resources.getResource((String)"schema/user.avsc").openStream());
    }

    @Before
    public void setup() throws Exception {
        TestUtil.run("create", "users", "--schema", "resource:schema/user.avsc");
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new SchemaCommand(this.console);
        this.command.setConf(new Configuration());
    }

    @After
    public void removeDatasets() throws Exception {
        TestUtil.run("delete", "users");
        TestUtil.run("delete", "users_2");
    }

    @Test
    public void testSchemaStdout() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info((String)Mockito.argThat(TestUtil.matchesSchema(schema)));
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:hive"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMultipleSchemasStdout() throws Exception {
        TestUtil.run("create", "users_2", "--schema", "resource:schema/user.avsc");
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users", "users_2"});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), Mockito.eq((Object)"users"), Mockito.argThat(TestUtil.matchesSchema(schema)));
        ((Logger)Mockito.verify((Object)this.console)).info(Mockito.anyString(), Mockito.eq((Object)"users_2"), Mockito.argThat(TestUtil.matchesSchema(schema)));
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:hive"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testSchemaToFile() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.outputPath = "target/user.avsc";
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        String fileContent = Files.toString((File)new File("target/user.avsc"), (Charset)BaseCommand.UTF8);
        Assert.assertTrue((String)"File should contain pretty printed schema", (boolean)TestUtil.matchesSchema(schema).matches((Object)fileContent));
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:hive"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMultipleSchemasToFileFails() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users", "users_2"});
        this.command.outputPath = "target/user_schemas.avsc";
        TestHelpers.assertThrows((String)"Should reject saving multiple schemas in a file", IllegalArgumentException.class, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestSchemaCommand.this.command.run();
                return null;
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMinimize() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.minimize = true;
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info((String)Mockito.argThat(TestUtil.matchesMinimizedSchema(schema)));
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:hive"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMissingDatasetName() {
        TestHelpers.assertThrows((String)"Should complain when no dataset name is given", IllegalArgumentException.class, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestSchemaCommand.this.command.run();
                return null;
            }
        });
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.console});
    }
}

