/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.hadoop.io.IOUtils;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.cli.commands.tarimport.avro.TarFileEntry;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Formats;
import org.kitesdk.data.View;
import org.slf4j.Logger;

@Parameters(commandDescription="Import files in tarball into a Dataset")
public class TarImportCommand
extends BaseDatasetCommand {
    private static final List<String> SUPPORTED_TAR_COMPRESSION_TYPES = Lists.newArrayList((Object[])new String[]{"", "none", "gzip", "bzip2"});
    private static final long DEFAULT_BLOCK_SIZE = 0x8000000L;
    @Parameter(description="<tar path> <dataset URI>")
    List<String> targets;
    @Parameter(names={"--compression"}, description="Override compression type (none, gzip, bzip2)")
    String compressionType = "";

    public TarImportCommand(Logger console) {
        super(console);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run() throws IOException {
        TarArchiveInputStream tis;
        View targetDataset;
        Preconditions.checkArgument((this.targets != null && this.targets.size() == 2 ? 1 : 0) != 0, (Object)"Tar path and target dataset URI are required.");
        Preconditions.checkArgument((boolean)SUPPORTED_TAR_COMPRESSION_TYPES.contains(this.compressionType), (Object)("Compression type " + this.compressionType + " is not supported"));
        String source = this.targets.get(0);
        String datasetUri = this.targets.get(1);
        long blockSize = this.getConf().getLong("dfs.blocksize", 0x8000000L);
        int success = 0;
        if (Datasets.exists((String)datasetUri)) {
            this.console.debug("Using existing dataset: {}", (Object)datasetUri);
            targetDataset = Datasets.load((String)datasetUri, TarFileEntry.class);
        } else {
            this.console.info("Creating new dataset: {}", (Object)datasetUri);
            DatasetDescriptor.Builder descriptorBuilder = new DatasetDescriptor.Builder();
            descriptorBuilder.format(Formats.AVRO);
            descriptorBuilder.schema(TarFileEntry.class);
            targetDataset = Datasets.create((String)datasetUri, (DatasetDescriptor)descriptorBuilder.build(), TarFileEntry.class);
        }
        DatasetWriter writer = targetDataset.newWriter();
        CompressionType tarCompressionType = CompressionType.NONE;
        if (this.compressionType.isEmpty()) {
            if (source.endsWith(".tar")) {
                tarCompressionType = CompressionType.NONE;
            } else if (source.endsWith(".tar.gz")) {
                tarCompressionType = CompressionType.GZIP;
            } else if (source.endsWith(".tar.bz2")) {
                tarCompressionType = CompressionType.BZIP2;
            }
        } else {
            tarCompressionType = this.compressionType.equals("gzip") ? CompressionType.GZIP : (this.compressionType.equals("bzip2") ? CompressionType.BZIP2 : CompressionType.NONE);
        }
        this.console.info("Using {} compression", (Object)tarCompressionType);
        switch (tarCompressionType) {
            case GZIP: {
                tis = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(this.open(source)));
                break;
            }
            case BZIP2: {
                tis = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(this.open(source)));
                break;
            }
            default: {
                tis = new TarArchiveInputStream(this.open(source));
            }
        }
        try {
            TarArchiveEntry entry;
            int count = 0;
            while ((entry = tis.getNextTarEntry()) != null) {
                if (entry.isDirectory()) continue;
                long size = entry.getSize();
                if (size >= blockSize) {
                    this.console.warn("Entry \"{}\" (size {}) is larger than the HDFS block size of {}. This may result in remote block reads", new Object[]{entry.getName(), size, blockSize});
                }
                byte[] buf = new byte[(int)size];
                try {
                    IOUtils.readFully((InputStream)tis, (byte[])buf, (int)0, (int)((int)size));
                }
                catch (IOException e) {
                    this.console.error("Did not read entry {} successfully (entry size {})", (Object)entry.getName(), (Object)size);
                    success = 1;
                    throw e;
                }
                writer.write((Object)TarFileEntry.newBuilder().setFilename(entry.getName()).setFilecontent(ByteBuffer.wrap(buf)).build());
                ++count;
            }
            this.console.info("Added {} records to \"{}\"", (Object)count, (Object)targetDataset.getDataset().getName());
        }
        finally {
            IOUtils.closeStream((Closeable)writer);
            IOUtils.closeStream((Closeable)tis);
        }
        return success;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Copy the contents of from sample.tar.gz to HDFS dataset \"sample\"", "path/to/sample.tar.gz dataset:hdfs:/path/to/sample"});
    }

    protected static enum CompressionType {
        NONE,
        GZIP,
        BZIP2;

    }
}

