/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Sets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.CSVImportCommand;
import org.kitesdk.cli.commands.CSVSchemaCommand;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.DatasetRecordException;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestCSVImportCommand {
    private static String sample;
    private static String avsc;
    private static String datasetName;
    private Logger console = null;
    private CSVImportCommand command;
    private Dataset<GenericData.Record> dataset;
    private static final Set<GenericData.Record> expected;

    @BeforeClass
    public static void createCSVSchemaAndSample() throws Exception {
        sample = "target/users.csv";
        avsc = "target/user.avsc";
        datasetName = "users";
        BufferedWriter writer = Files.newWriter((File)new File(sample), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        writer.append("1,test,test@example.com\n");
        writer.append("2,user,user@example.com\n");
        writer.close();
        TestUtil.run("-v", "csv-schema", sample, "-o", avsc, "--class", "User", "--require", "id");
        GenericRecordBuilder builder = new GenericRecordBuilder(new Schema.Parser().parse(new File(avsc)));
        builder.set("id", (Object)1L);
        builder.set("username", (Object)"test");
        builder.set("email", (Object)"test@example.com");
        expected.add(builder.build());
        builder.set("id", (Object)2L);
        builder.set("username", (Object)"user");
        builder.set("email", (Object)"user@example.com");
        expected.add(builder.build());
    }

    @Before
    public void setup() throws Exception {
        TestUtil.run("-v", "create", datasetName, "--use-local", "-d", "target/data", "-s", avsc);
        this.dataset = (Dataset)Datasets.load((URI)URIBuilder.build((String)"repo:file:target/data", (String)"default", (String)datasetName), GenericData.Record.class);
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new CSVImportCommand(this.console);
        this.command.setConf(new Configuration());
        this.command.local = true;
        this.command.directory = "target/data";
    }

    @After
    public void removeData() throws Exception {
        TestUtil.run("delete", datasetName, "--use-local", "-d", "target/data");
    }

    @Test
    public void testBasicImport() throws Exception {
        this.command.targets = Lists.newArrayList((Object[])new String[]{sample, datasetName});
        this.command.run();
        Assert.assertEquals((String)"Should contain expected records", expected, (Object)DatasetTestUtilities.materialize(this.dataset));
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:target/data"));
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)2L, (Object)datasetName);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testDirectoryImport() throws Exception {
        new File("target/sample").mkdir();
        BufferedWriter writer = Files.newWriter((File)new File("target/sample/one.csv"), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        writer.append("1,test,test@example.com\n");
        writer.close();
        writer = Files.newWriter((File)new File("target/sample/two.csv"), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        writer.append("2,user,user@example.com\n");
        writer.close();
        this.command.targets = Lists.newArrayList((Object[])new String[]{"target/sample", datasetName});
        this.command.run();
        Assert.assertEquals((String)"Should contain expected records", expected, (Object)DatasetTestUtilities.materialize(this.dataset));
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:target/data"));
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)2L, (Object)datasetName);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMissingSamplePath() throws Exception {
        this.command.targets = Lists.newArrayList((Object[])new String[]{"missing.csv", datasetName});
        TestHelpers.assertThrows((String)"Should complain about missing CSV data path", IllegalArgumentException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCSVImportCommand.this.command.run();
                return null;
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testEmptySampleDirectory() throws Exception {
        new File("target/emptyDir").mkdir();
        this.command.targets = Lists.newArrayList((Object[])new String[]{"target/emptyDir", datasetName});
        TestHelpers.assertThrows((String)"Should complain about no data files", IllegalArgumentException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCSVImportCommand.this.command.run();
                return null;
            }
        });
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:target/data"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMissingDataset() throws Exception {
        this.command.targets = Lists.newArrayList((Object[])new String[]{sample, "notadataset"});
        TestHelpers.assertThrows((String)"Should complain about missing dataset", DatasetNotFoundException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCSVImportCommand.this.command.run();
                return null;
            }
        });
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:target/data"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testIncompatibleSchemaFieldType() throws Exception {
        BufferedWriter writer = Files.newWriter((File)new File("target/incompatible.csv"), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        writer.append("NaN,test,test@example.com\n");
        writer.close();
        this.command.targets = Lists.newArrayList((Object[])new String[]{"target/incompatible.csv", datasetName});
        TestHelpers.assertThrows((String)"Should complain about schema compatibility", DatasetRecordException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCSVImportCommand.this.command.run();
                return null;
            }
        });
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:target/data"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    static {
        expected = Sets.newHashSet();
    }
}

