/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.cli.commands.CreateColumnMappingCommand;
import org.kitesdk.data.ColumnMapping;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestCreateColumnMappingCommand {
    private Logger console;
    private CreateColumnMappingCommand command;

    @Before
    public void setupCommand() {
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new CreateColumnMappingCommand(this.console);
        this.command.setConf(new Configuration());
        this.command.avroSchemaFile = "resource:test-schemas/hbase-user.avsc";
        this.command.partitionStrategyFile = "resource:test-partitions/email-part.json";
    }

    @Test
    public void testBasic() throws Exception {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"email:key", "username:u", "created_at:u"});
        this.command.run();
        ColumnMapping mapping = new ColumnMapping.Builder().key("email").column("username", "u", "username").counter("created_at", "u", "created_at").build();
        ((Logger)Mockito.verify((Object)this.console)).info(mapping.toString(true));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testQualifier() throws Exception {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"email:key", "username:u:n"});
        this.command.run();
        ColumnMapping mapping = new ColumnMapping.Builder().key("email").column("username", "u", "n").build();
        ((Logger)Mockito.verify((Object)this.console)).info(mapping.toString(true));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testVersion() throws Exception {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"email:key", "username:u:n", "version:version"});
        this.command.run();
        ColumnMapping mapping = new ColumnMapping.Builder().version("version").key("email").column("username", "u", "n").build();
        ((Logger)Mockito.verify((Object)this.console)).info(mapping.toString(true));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testVersionWithCounterTypes() throws Exception {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"email:key", "version:version", "username:u", "created_at:u"});
        this.command.run();
        ColumnMapping mapping = new ColumnMapping.Builder().version("version").key("email").column("username", "u", "username").column("created_at", "u", "created_at").build();
        ((Logger)Mockito.verify((Object)this.console)).info(mapping.toString(true));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCounter() throws Exception {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"email:key", "username:u", "created_at:u"});
        this.command.run();
        ColumnMapping mapping = new ColumnMapping.Builder().key("email").column("username", "u", "username").counter("created_at", "u", "created_at").build();
        ((Logger)Mockito.verify((Object)this.console)).info(mapping.toString(true));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCounterWithQualifier() throws Exception {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"email:key", "username:u", "created_at:u:ts"});
        this.command.run();
        ColumnMapping mapping = new ColumnMapping.Builder().key("email").column("username", "u", "username").counter("created_at", "u", "ts").build();
        ((Logger)Mockito.verify((Object)this.console)).info(mapping.toString(true));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testKAC() throws Exception {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"email:key", "username:u", "preferences:prefs"});
        this.command.run();
        ColumnMapping mapping = new ColumnMapping.Builder().key("email").column("username", "u", "username").keyAsColumn("preferences", "prefs").build();
        ((Logger)Mockito.verify((Object)this.console)).info(mapping.toString(true));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testKACWithPrefix() throws Exception {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"email:key", "username:u", "preferences:prefs:p_"});
        this.command.run();
        ColumnMapping mapping = new ColumnMapping.Builder().key("email").column("username", "u", "username").keyAsColumn("preferences", "prefs", "p_").build();
        ((Logger)Mockito.verify((Object)this.console)).info(mapping.toString(true));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMissingKeyPartition() throws Exception {
        this.command.partitionStrategyFile = "resource:test-partitions/email-hash-part.json";
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"email:key"});
        TestHelpers.assertThrows((String)"Should reject missing partitioner", ValidationException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCreateColumnMappingCommand.this.command.run();
                return null;
            }
        });
    }

    @Test
    public void testUnknownKeySourceField() {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"panda:key"});
        TestHelpers.assertThrows((String)"Should reject unknown key field \"panda\"", ValidationException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCreateColumnMappingCommand.this.command.run();
                return null;
            }
        });
    }

    @Test
    public void testUnknownVersionSourceField() {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"grizzly:version"});
        TestHelpers.assertThrows((String)"Should reject unknown version field \"grizzly\"", ValidationException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCreateColumnMappingCommand.this.command.run();
                return null;
            }
        });
    }

    @Test
    public void testUnknownSourceField() {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"koala:u"});
        TestHelpers.assertThrows((String)"Should reject unknown field \"koala\"", ValidationException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCreateColumnMappingCommand.this.command.run();
                return null;
            }
        });
    }

    @Test
    public void testMissingFamily() {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"gummi:"});
        TestHelpers.assertThrows((String)"Should reject missing family for \"gummi\"", ValidationException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCreateColumnMappingCommand.this.command.run();
                return null;
            }
        });
    }

    @Test
    public void testUnknownMapping() {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"kodiak"});
        TestHelpers.assertThrows((String)"Should reject unknown mapping \"kodiak\"", ValidationException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCreateColumnMappingCommand.this.command.run();
                return null;
            }
        });
    }
}

