/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.cli.commands.CreatePartitionStrategyCommand;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestCreatePartitionStrategyCommand {
    private Logger console;
    private CreatePartitionStrategyCommand command;

    @Before
    public void setupCommand() {
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new CreatePartitionStrategyCommand(this.console);
        this.command.setConf(new Configuration());
        this.command.avroSchemaFile = "resource:test-schemas/user.avsc";
    }

    @Test
    public void testBasic() throws Exception {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"username:hash[16]", "username:copy"});
        this.command.run();
        PartitionStrategy strategy = new PartitionStrategy.Builder().hash("username", 16).identity("username").build();
        ((Logger)Mockito.verify((Object)this.console)).info(strategy.toString(true));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testTime() throws Exception {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"created_at:year", "created_at:month", "created_at:day", "created_at:hour", "created_at:minute"});
        this.command.run();
        PartitionStrategy strategy = new PartitionStrategy.Builder().year("created_at").month("created_at").day("created_at").hour("created_at").minute("created_at").build();
        ((Logger)Mockito.verify((Object)this.console)).info(strategy.toString(true));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMissingWidth() throws Exception {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"username:hash"});
        TestHelpers.assertThrows((String)"Should reject missing hash width", ValidationException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCreatePartitionStrategyCommand.this.command.run();
                return null;
            }
        });
    }

    @Test
    public void testUnknownSourceField() {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"id:copy"});
        TestHelpers.assertThrows((String)"Should reject missing field \"id\"", ValidationException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCreatePartitionStrategyCommand.this.command.run();
                return null;
            }
        });
    }

    @Test
    public void testUnknownType() {
        this.command.partitions = Lists.newArrayList((Object[])new String[]{"username:id"});
        TestHelpers.assertThrows((String)"Should unknown partition function \"id\"", ValidationException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestCreatePartitionStrategyCommand.this.command.run();
                return null;
            }
        });
    }
}

