/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.cli.commands.DeleteCommand;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.MockRepositories;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.spi.AbstractDataset;
import org.kitesdk.data.spi.AbstractRefinableView;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.DatasetRepository;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestDeleteCommand {
    private DatasetRepository repo;
    private DeleteCommand command;
    private Logger console;

    @Before
    public void setUp() {
        this.repo = MockRepositories.newMockRepository();
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new DeleteCommand(this.console);
        this.command.repoURI = this.repo.getUri().toString();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).getUri();
    }

    @Test
    public void testBasicUse() throws Exception {
        this.command.targets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.run();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).delete("default", "users");
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Deleted"), Mockito.eq((Object)"users"));
    }

    @Test
    public void testMultipleDatasets() throws Exception {
        this.command.targets = Lists.newArrayList((Object[])new String[]{"users", "moreusers"});
        this.command.run();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).delete("default", "users");
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Deleted"), Mockito.eq((Object)"users"));
        ((DatasetRepository)Mockito.verify((Object)this.repo)).delete("default", "moreusers");
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Deleted"), Mockito.eq((Object)"moreusers"));
    }

    @Test
    public void testDatasetUri() throws Exception {
        String datasetUri = new URIBuilder(this.repo.getUri(), "ns", "test").build().toString();
        Assert.assertTrue((String)"Should be a dataset URI", (boolean)datasetUri.startsWith("dataset:"));
        this.command.targets = Lists.newArrayList((Object[])new String[]{datasetUri});
        this.command.run();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).delete("ns", "test");
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Deleted"), Mockito.eq((Object)datasetUri));
    }

    @Test
    public void testViewUri() throws Exception {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().schema((Schema)SchemaBuilder.record((String)"Test").fields().requiredInt("prop").endRecord()).build();
        URI actualViewUri = new URIBuilder(this.repo.getUri(), "ns", "test").with("prop", (Object)"34").build();
        String viewUri = actualViewUri.toString();
        Assert.assertTrue((String)"Should be a view URI", (boolean)viewUri.startsWith("view:"));
        AbstractDataset ds = (AbstractDataset)Mockito.mock(AbstractDataset.class);
        Mockito.when((Object)this.repo.load("ns", "test", GenericRecord.class)).thenReturn((Object)ds);
        Mockito.when((Object)ds.getDescriptor()).thenReturn((Object)desc);
        AbstractRefinableView view = (AbstractRefinableView)Mockito.mock(AbstractRefinableView.class);
        Mockito.when((Object)ds.filter((Constraints)Matchers.any(Constraints.class))).thenReturn((Object)view);
        Mockito.when((Object)view.getUri()).thenReturn((Object)actualViewUri);
        this.command.targets = Lists.newArrayList((Object[])new String[]{viewUri});
        this.command.run();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("ns", "test", GenericRecord.class);
        ((AbstractRefinableView)Mockito.verify((Object)view)).deleteAll();
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Deleted"), Mockito.eq((Object)viewUri));
    }

    @Test
    public void testViewUriWithTypo() throws Exception {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().schema((Schema)SchemaBuilder.record((String)"Test").fields().requiredLong("ts").endRecord()).partitionStrategy(new PartitionStrategy.Builder().year("ts").month("ts").day("ts").build()).build();
        String viewUri = new URIBuilder(this.repo.getUri(), "ns", "test").with("year", (Object)"2014").with("month", (Object)"3").with("dy", (Object)"14").build().toString();
        URI actualViewUri = new URIBuilder(this.repo.getUri(), "ns", "test").with("month", (Object)"3").with("year", (Object)"2014").build();
        Assert.assertTrue((String)"Should be a view URI", (boolean)viewUri.startsWith("view:"));
        AbstractDataset ds = (AbstractDataset)Mockito.mock(AbstractDataset.class);
        Mockito.when((Object)this.repo.load("ns", "test", GenericRecord.class)).thenReturn((Object)ds);
        Mockito.when((Object)ds.getDescriptor()).thenReturn((Object)desc);
        AbstractRefinableView view = (AbstractRefinableView)Mockito.mock(AbstractRefinableView.class);
        Mockito.when((Object)ds.filter((Constraints)Matchers.any(Constraints.class))).thenReturn((Object)view);
        Mockito.when((Object)view.getUri()).thenReturn((Object)actualViewUri);
        this.command.targets = Lists.newArrayList((Object[])new String[]{viewUri});
        TestHelpers.assertThrows((String)"Should reject a view with missing attribute", IllegalArgumentException.class, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    TestDeleteCommand.this.command.run();
                }
                catch (IOException e) {
                    throw new RuntimeException("Caught IOException", e);
                }
            }
        });
    }

    @Test
    public void testViewMatches() {
        Assert.assertTrue((String)"Identical URI passes", (boolean)DeleteCommand.viewMatches((URI)URI.create("view:file:/path/to/dataset?year=2014&month=3&day=14"), (String)"view:file:/path/to/dataset?year=2014&month=3&day=14"));
        Assert.assertTrue((String)"Extra settings pass", (boolean)DeleteCommand.viewMatches((URI)URI.create("view:file:/path/to/dataset?year=2014&month=3&day=14&a=b"), (String)"view:file:/path/to/dataset?year=2014&month=3&day=14"));
        Assert.assertFalse((String)"Missing year fails", (boolean)DeleteCommand.viewMatches((URI)URI.create("view:file:/path/to/dataset?month=3&day=14"), (String)"view:file:/path/to/dataset?year=2014&month=3&day=14"));
        Assert.assertFalse((String)"Missing month fails", (boolean)DeleteCommand.viewMatches((URI)URI.create("view:file:/path/to/dataset?year=2014&day=14"), (String)"view:file:/path/to/dataset?year=2014&month=3&day=14"));
        Assert.assertFalse((String)"Missing day fails", (boolean)DeleteCommand.viewMatches((URI)URI.create("view:file:/path/to/dataset?year=2014&month=3"), (String)"view:file:/path/to/dataset?year=2014&month=3&day=14"));
    }
}

