/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.BaseCommand;
import org.kitesdk.cli.commands.ObjectSchemaCommand;
import org.kitesdk.cli.example.User;
import org.kitesdk.data.TestHelpers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestObjectSchemaCommand {
    private static Schema schema = null;
    private Logger console = null;
    private ObjectSchemaCommand command;

    @BeforeClass
    public static void buildUserSchema() throws Exception {
        schema = ReflectData.get().getSchema(User.class);
    }

    @Before
    public void setup() throws Exception {
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new ObjectSchemaCommand(this.console);
        this.command.setConf(new Configuration());
    }

    @Test
    public void testSchemaStdout() throws Exception {
        this.command.classNames = Lists.newArrayList((Object[])new String[]{"org.kitesdk.cli.example.User"});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info((String)Mockito.argThat(TestUtil.matchesSchema(schema)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testSchemaToFile() throws Exception {
        this.command.classNames = Lists.newArrayList((Object[])new String[]{"org.kitesdk.cli.example.User"});
        this.command.outputPath = "target/user.avsc";
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        String fileContent = Files.toString((File)new File("target/user.avsc"), (Charset)BaseCommand.UTF8);
        Assert.assertTrue((String)"File should contain pretty printed schema", (boolean)TestUtil.matchesSchema(schema).matches((Object)fileContent));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMultipleSClassesFail() throws Exception {
        this.command.classNames = Lists.newArrayList((Object[])new String[]{"org.kitesdk.cli.example.User", "org.kitesdk.data.Format"});
        TestHelpers.assertThrows((String)"Should reject saving multiple schemas in a file", IllegalArgumentException.class, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestObjectSchemaCommand.this.command.run();
                return null;
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMinimize() throws Exception {
        this.command.classNames = Lists.newArrayList((Object[])new String[]{"org.kitesdk.cli.example.User"});
        this.command.minimize = true;
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        ((Logger)Mockito.verify((Object)this.console)).info((String)Mockito.argThat(TestUtil.matchesMinimizedSchema(schema)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMissingSamplePath() {
        TestHelpers.assertThrows((String)"Should complain when no class name is given", IllegalArgumentException.class, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestObjectSchemaCommand.this.command.run();
                return null;
            }
        });
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.console});
    }
}

