/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.BaseCommand;
import org.kitesdk.cli.commands.CSVSchemaCommand;
import org.kitesdk.cli.commands.ObjectSchemaCommand;
import org.kitesdk.cli.commands.SchemaCommand;
import org.kitesdk.cli.example.User;
import org.kitesdk.data.MiniDFSTest;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestSchemaCommandCluster
extends MiniDFSTest {
    private static String repoURI = null;
    private Logger console = null;

    @BeforeClass
    public static void createCSVSample() throws Exception {
        repoURI = "repo:" + TestSchemaCommandCluster.getDFS().getUri().toString() + "/tmp/data";
    }

    @Before
    public void setup() throws Exception {
        this.console = (Logger)Mockito.mock(Logger.class);
    }

    @Test
    public void testObjSchemaToFile() throws Exception {
        Schema schema = ReflectData.get().getSchema(User.class);
        ObjectSchemaCommand command = new ObjectSchemaCommand(this.console);
        command.setConf(TestSchemaCommandCluster.getConfiguration());
        command.classNames = Lists.newArrayList((Object[])new String[]{"org.kitesdk.cli.example.User"});
        command.outputPath = "target/obj.avsc";
        int rc = command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        String fileContent = Files.toString((File)new File("target/obj.avsc"), (Charset)BaseCommand.UTF8);
        Assert.assertTrue((String)"File should contain pretty printed schema", (boolean)TestUtil.matchesSchema(schema).matches((Object)fileContent));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testObjSchemaToHDFSFile() throws Exception {
        Schema schema = ReflectData.get().getSchema(User.class);
        String hdfsSchemaPath = "hdfs:/tmp/schemas/obj.avsc";
        ObjectSchemaCommand command = new ObjectSchemaCommand(this.console);
        command.setConf(TestSchemaCommandCluster.getConfiguration());
        command.classNames = Lists.newArrayList((Object[])new String[]{"org.kitesdk.cli.example.User"});
        command.outputPath = hdfsSchemaPath;
        int rc = command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        String fileContent = CharStreams.toString((Readable)new InputStreamReader((InputStream)TestSchemaCommandCluster.getDFS().open(new Path(hdfsSchemaPath)), "utf8"));
        Assert.assertTrue((String)"File should contain pretty printed schema", (boolean)TestUtil.matchesSchema(schema).matches((Object)fileContent));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCSVSchemaToFile() throws Exception {
        String csvSample = "target/users.csv";
        BufferedWriter writer = Files.newWriter((File)new File(csvSample), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id, username, email\n");
        writer.append("1, test, test@example.com\n");
        writer.close();
        Schema schema = (Schema)SchemaBuilder.record((String)"User").fields().optionalLong("id").optionalString("username").optionalString("email").endRecord();
        CSVSchemaCommand command = new CSVSchemaCommand(this.console);
        command.setConf(TestSchemaCommandCluster.getConfiguration());
        command.samplePaths = Lists.newArrayList((Object[])new String[]{csvSample});
        command.outputPath = "target/csv.avsc";
        command.recordName = "User";
        int rc = command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        String fileContent = Files.toString((File)new File("target/csv.avsc"), (Charset)BaseCommand.UTF8);
        Assert.assertTrue((String)"File should contain pretty printed schema", (boolean)TestUtil.matchesSchema(schema).matches((Object)fileContent));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCSVSchemaToHDFSFile() throws Exception {
        String csvSample = "target/users.csv";
        BufferedWriter writer = Files.newWriter((File)new File(csvSample), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id, username, email\n");
        writer.append("1, test, test@example.com\n");
        writer.close();
        Schema schema = (Schema)SchemaBuilder.record((String)"User").fields().optionalLong("id").optionalString("username").optionalString("email").endRecord();
        String hdfsSchemaPath = "hdfs:/tmp/schemas/csv.avsc";
        CSVSchemaCommand command = new CSVSchemaCommand(this.console);
        command.setConf(TestSchemaCommandCluster.getConfiguration());
        command.samplePaths = Lists.newArrayList((Object[])new String[]{csvSample});
        command.outputPath = hdfsSchemaPath;
        command.recordName = "User";
        int rc = command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        String fileContent = CharStreams.toString((Readable)new InputStreamReader((InputStream)TestSchemaCommandCluster.getDFS().open(new Path(hdfsSchemaPath)), "utf8"));
        Assert.assertTrue((String)"File should contain pretty printed schema", (boolean)TestUtil.matchesSchema(schema).matches((Object)fileContent));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testHDFSCSVSchemaToFile() throws Exception {
        String csvSample = "hdfs:/tmp/sample/users.csv";
        FSDataOutputStream out = TestSchemaCommandCluster.getDFS().create(new Path(csvSample), true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "utf8");
        writer.append("id, username, email\n");
        writer.append("1, test, test@example.com\n");
        writer.close();
        Schema schema = (Schema)SchemaBuilder.record((String)"User").fields().optionalLong("id").optionalString("username").optionalString("email").endRecord();
        CSVSchemaCommand command = new CSVSchemaCommand(this.console);
        command.setConf(TestSchemaCommandCluster.getConfiguration());
        command.samplePaths = Lists.newArrayList((Object[])new String[]{csvSample});
        command.outputPath = "target/csv2.avsc";
        command.recordName = "User";
        int rc = command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        String fileContent = Files.toString((File)new File("target/csv2.avsc"), (Charset)BaseCommand.UTF8);
        Assert.assertTrue((String)"File should contain pretty printed schema", (boolean)TestUtil.matchesSchema(schema).matches((Object)fileContent));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testHDFSCSVSchemaToHDFSFile() throws Exception {
        String csvSample = "hdfs:/tmp/sample/users.csv";
        FSDataOutputStream out = TestSchemaCommandCluster.getDFS().create(new Path(csvSample), true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "utf8");
        writer.append("id, username, email\n");
        writer.append("1, test, test@example.com\n");
        writer.close();
        Schema schema = (Schema)SchemaBuilder.record((String)"User").fields().optionalLong("id").optionalString("username").optionalString("email").endRecord();
        String hdfsSchemaPath = "hdfs:/tmp/schemas/csv2.avsc";
        CSVSchemaCommand command = new CSVSchemaCommand(this.console);
        command.setConf(TestSchemaCommandCluster.getConfiguration());
        command.samplePaths = Lists.newArrayList((Object[])new String[]{csvSample});
        command.outputPath = hdfsSchemaPath;
        command.recordName = "User";
        int rc = command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        String fileContent = CharStreams.toString((Readable)new InputStreamReader((InputStream)TestSchemaCommandCluster.getDFS().open(new Path(hdfsSchemaPath)), "utf8"));
        Assert.assertTrue((String)"File should contain pretty printed schema", (boolean)TestUtil.matchesSchema(schema).matches((Object)fileContent));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testDatasetSchemaToFile() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"schema/user.avsc").openStream());
        TestUtil.run("create", "users", "--schema", "resource:schema/user.avsc", "-r", repoURI);
        SchemaCommand command = new SchemaCommand(this.console);
        command.setConf(TestSchemaCommandCluster.getConfiguration());
        command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        command.outputPath = "target/user.avsc";
        command.repoURI = repoURI;
        int rc = command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        String fileContent = Files.toString((File)new File("target/user.avsc"), (Charset)BaseCommand.UTF8);
        Assert.assertTrue((String)"File should contain pretty printed schema", (boolean)TestUtil.matchesSchema(schema).matches((Object)fileContent));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
        TestUtil.run("delete", "users", "-r", repoURI);
    }

    @Test
    public void testDatasetSchemaToHDFSFile() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"schema/user.avsc").openStream());
        TestUtil.run("create", "users", "--schema", "resource:schema/user.avsc", "-r", repoURI);
        String hdfsSchemaPath = "hdfs:/tmp/schemas/user.avsc";
        SchemaCommand command = new SchemaCommand(this.console);
        command.setConf(TestSchemaCommandCluster.getConfiguration());
        command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        command.outputPath = hdfsSchemaPath;
        command.repoURI = repoURI;
        int rc = command.run();
        Assert.assertEquals((String)"Should return success code", (long)0L, (long)rc);
        String fileContent = CharStreams.toString((Readable)new InputStreamReader((InputStream)TestSchemaCommandCluster.getDFS().open(new Path(hdfsSchemaPath)), "utf8"));
        Assert.assertTrue((String)"File should contain pretty printed schema", (boolean)TestUtil.matchesSchema(schema).matches((Object)fileContent));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
        TestUtil.run("delete", "users", "-r", repoURI);
    }
}

