/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.CSVSchemaCommand;
import org.kitesdk.cli.commands.ShowRecordsCommand;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.TestHelpers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestShowRecordsCommand {
    private Logger console = null;
    private ShowRecordsCommand command;

    @BeforeClass
    public static void createDatasetFromCSV() throws Exception {
        String sample = "target/users.csv";
        String avsc = "target/user.avsc";
        BufferedWriter writer = Files.newWriter((File)new File(sample), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        writer.append("1,test,test@example.com\n");
        writer.append("2,user,user@example.com\n");
        writer.close();
        TestUtil.run("delete", "users", "--use-local", "-d", "target/data");
        TestUtil.run("-v", "csv-schema", sample, "-o", avsc, "--class", "User");
        TestUtil.run("-v", "create", "users", "--use-local", "-d", "target/data", "-s", avsc);
        TestUtil.run("-v", "csv-import", sample, "--use-local", "-d", "target/data", "users");
    }

    @AfterClass
    public static void removeData() throws Exception {
        TestUtil.run("delete", "users", "--use-local", "-d", "target/data");
    }

    @Before
    public void setup() throws Exception {
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new ShowRecordsCommand(this.console);
        this.command.local = true;
        this.command.directory = "target/data";
    }

    @Test
    public void testDefaultArgs() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.run();
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:target/data"));
        ((Logger)Mockito.verify((Object)this.console)).info("{\"id\": 1, \"username\": \"test\", \"email\": \"test@example.com\"}");
        ((Logger)Mockito.verify((Object)this.console)).info("{\"id\": 2, \"username\": \"user\", \"email\": \"user@example.com\"}");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testNumRecords() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.numRecords = 1;
        this.command.run();
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:target/data"));
        ((Logger)Mockito.verify((Object)this.console)).info("{\"id\": 1, \"username\": \"test\", \"email\": \"test@example.com\"}");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testZeroRecords() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.numRecords = 0;
        this.command.run();
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:target/data"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testNegativeNumRecords() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.numRecords = -1;
        this.command.run();
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:target/data"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testMissingDataset() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"notadataset"});
        TestHelpers.assertThrows((String)"Should complain about missing dataset", DatasetNotFoundException.class, (Callable)new Callable(){

            public Object call() throws Exception {
                TestShowRecordsCommand.this.command.run();
                return null;
            }
        });
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:target/data"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }
}

