/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.cli.Command;
import org.kitesdk.data.spi.HadoopFileSystemURLStreamHandler;
import org.slf4j.Logger;

public abstract class BaseCommand
implements Command,
Configurable {
    @VisibleForTesting
    static final Charset UTF8 = Charset.forName("utf8");
    private static final String RESOURCE_URI_SCHEME = "resource";
    private static final String STDIN_AS_SOURCE = "stdin";
    private Configuration conf = null;
    private LocalFileSystem localFS = null;

    public FileSystem defaultFS() throws IOException {
        if (this.localFS == null) {
            this.localFS = FileSystem.getLocal((Configuration)this.getConf());
        }
        return this.localFS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(String content, Logger console, String filename) throws IOException {
        if (filename == null || "-".equals(filename)) {
            console.info(content);
        } else {
            FSDataOutputStream outgoing = this.create(filename);
            try {
                outgoing.write(content.getBytes(UTF8));
            }
            finally {
                outgoing.close();
            }
        }
    }

    public FSDataOutputStream create(String filename) throws IOException {
        return this.create(filename, true);
    }

    public FSDataOutputStream createWithChecksum(String filename) throws IOException {
        return this.create(filename, false);
    }

    private FSDataOutputStream create(String filename, boolean noChecksum) throws IOException {
        Path filePath = this.qualifiedPath(filename);
        FileSystem fs = filePath.getFileSystem(this.getConf());
        if (noChecksum && fs instanceof ChecksumFileSystem) {
            fs = ((ChecksumFileSystem)fs).getRawFileSystem();
        }
        return fs.create(filePath, true);
    }

    public Path qualifiedPath(String filename) throws IOException {
        Path cwd = this.defaultFS().makeQualified(new Path("."));
        return new Path(filename).makeQualified(this.defaultFS().getUri(), cwd);
    }

    public URI qualifiedURI(String filename) throws IOException {
        URI fileURI = URI.create(filename);
        if (RESOURCE_URI_SCHEME.equals(fileURI.getScheme())) {
            return fileURI;
        }
        return this.qualifiedPath(filename).toUri();
    }

    public InputStream open(String filename) throws IOException {
        if (STDIN_AS_SOURCE.equals(filename)) {
            return System.in;
        }
        URI uri = this.qualifiedURI(filename);
        if (RESOURCE_URI_SCHEME.equals(uri.getScheme())) {
            return Resources.getResource((String)uri.getRawSchemeSpecificPart()).openStream();
        }
        Path filePath = new Path(uri);
        FileSystem fs = filePath.getFileSystem(this.getConf());
        return fs.open(filePath);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        HadoopFileSystemURLStreamHandler.setDefaultConf((Configuration)conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected static ClassLoader loaderFor(List<String> jars, List<String> paths) throws MalformedURLException {
        return AccessController.doPrivileged(new GetClassLoader(BaseCommand.urls(jars, paths)));
    }

    protected static ClassLoader loaderForJars(List<String> jars) throws MalformedURLException {
        return AccessController.doPrivileged(new GetClassLoader(BaseCommand.urls(jars, null)));
    }

    protected static ClassLoader loaderForPaths(List<String> paths) throws MalformedURLException {
        return AccessController.doPrivileged(new GetClassLoader(BaseCommand.urls(null, paths)));
    }

    private static List<URL> urls(List<String> jars, List<String> dirs) throws MalformedURLException {
        File path;
        List urls = Lists.newArrayList();
        if (dirs != null) {
            for (String lib : dirs) {
                path = lib.endsWith("/") ? new File(lib) : new File(lib + "/");
                Preconditions.checkArgument((boolean)path.exists(), (Object)("Lib directory does not exist: " + lib));
                Preconditions.checkArgument((boolean)path.isDirectory(), (Object)("Not a directory: " + lib));
                Preconditions.checkArgument((path.canRead() && path.canExecute() ? 1 : 0) != 0, (Object)("Insufficient permissions to access lib directory: " + lib));
                urls.add(path.toURI().toURL());
            }
        }
        if (jars != null) {
            for (String jar : jars) {
                path = new File(jar);
                Preconditions.checkArgument((boolean)path.exists(), (Object)("Jar files does not exist: " + jar));
                Preconditions.checkArgument((boolean)path.isFile(), (Object)("Not a file: " + jar));
                Preconditions.checkArgument((boolean)path.canRead(), (Object)("Cannot read jar file: " + jar));
                urls.add(path.toURI().toURL());
            }
        }
        return urls;
    }

    private static class GetClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final URL[] urls;

        public GetClassLoader(List<URL> urls) {
            this.urls = urls.toArray(new URL[urls.size()]);
        }

        @Override
        public ClassLoader run() {
            return new URLClassLoader(this.urls, Thread.currentThread().getContextClassLoader());
        }
    }
}

