/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.kitesdk.cli.commands.BaseCommand;
import org.kitesdk.data.ColumnMapping;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.ValidationException;
import org.slf4j.Logger;

@Parameters(commandDescription="Builds a partition strategy for a schema")
public class CreateColumnMappingCommand
extends BaseCommand {
    private static final Pattern KEY_MAPPING = Pattern.compile("(\\w+):key");
    private static final Pattern VERSION_MAPPING = Pattern.compile("(\\w+):version");
    private static final Pattern FIELD_MAPPING = Pattern.compile("(\\w+):(\\w+)(?::(\\w+))?");
    private static final Set<Schema.Type> counterTypes = Sets.newHashSet((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG});
    private static final Set<Schema.Type> kacTypes = Sets.newHashSet((Object[])new Schema.Type[]{Schema.Type.RECORD, Schema.Type.MAP});
    private final Logger console;
    @Parameter(description="<field:type pairs>")
    List<String> partitions;
    @Parameter(names={"-s", "--schema"}, required=true, description="The file containing the Avro schema.")
    String avroSchemaFile;
    @Parameter(names={"-p", "--partition-by"}, required=true, description="The file containing the JSON partition strategy.")
    String partitionStrategyFile;
    @Parameter(names={"--minimize"}, description="Minimize output size by eliminating white space")
    boolean minimize = false;
    @Parameter(names={"-o", "--output"}, description="Save schema avsc to path")
    @SuppressWarnings(value={"UWF_NULL_FIELD"}, justification="Field set by JCommander")
    String outputPath = null;

    public CreateColumnMappingCommand(Logger console) {
        this.console = console;
    }

    @Override
    public int run() throws IOException {
        String source;
        Matcher matcher;
        String mapping2;
        Schema schema = new Schema.Parser().parse(this.open(this.avroSchemaFile));
        boolean hasVersion = false;
        ColumnMapping.Builder mappingBuilder = new ColumnMapping.Builder();
        for (String mapping2 : this.partitions) {
            matcher = VERSION_MAPPING.matcher(mapping2);
            if (!matcher.matches()) continue;
            source = matcher.group(1);
            ValidationException.check((schema.getField(source) != null ? 1 : 0) != 0, (String)"Not a schema field: %s", (Object[])new Object[]{source});
            mappingBuilder.occ(source);
            hasVersion = true;
        }
        for (String mapping2 : this.partitions) {
            matcher = KEY_MAPPING.matcher(mapping2);
            if (matcher.matches()) {
                source = matcher.group(1);
                ValidationException.check((schema.getField(source) != null ? 1 : 0) != 0, (String)"Not a schema field: %s", (Object[])new Object[]{source});
                mappingBuilder.key(source);
                continue;
            }
            matcher = VERSION_MAPPING.matcher(mapping2);
            if (matcher.matches()) continue;
            matcher = FIELD_MAPPING.matcher(mapping2);
            if (matcher.matches()) {
                source = matcher.group(1);
                String family = matcher.group(2);
                String qualOrPrefix = matcher.group(3);
                Schema.Field field = schema.getField(source);
                ValidationException.check((field != null ? 1 : 0) != 0, (String)"Not a schema field: %s", (Object[])new Object[]{source});
                ValidationException.check((family != null && !family.isEmpty() ? 1 : 0) != 0, (String)"Missing column family: %s:?", (Object[])new Object[]{source});
                Schema.Type type = schema.getField(source).schema().getType();
                if (!hasVersion && counterTypes.contains(type)) {
                    if (qualOrPrefix == null) {
                        mappingBuilder.counter(source, family, source);
                        continue;
                    }
                    mappingBuilder.counter(source, family, qualOrPrefix);
                    continue;
                }
                if (kacTypes.contains(type)) {
                    mappingBuilder.keyAsColumn(source, family, qualOrPrefix);
                    continue;
                }
                if (qualOrPrefix == null) {
                    mappingBuilder.column(source, family, source);
                    continue;
                }
                mappingBuilder.column(source, family, qualOrPrefix);
                continue;
            }
            throw new ValidationException("Unknown mapping: " + mapping2);
        }
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().columnMapping(mappingBuilder.build()).schema(this.open(this.avroSchemaFile)).partitionStrategy(this.open(this.partitionStrategyFile)).build();
        mapping2 = descriptor.getColumnMapping().toString(!this.minimize);
        this.output(mapping2, this.console, this.outputPath);
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# store email in the key, other fields in column family \"u\":", "email:key username:u id:u --schema user.avsc -o user-cols.json", "# store preferences hash-map in column family \"prefs\":", "... preferences:prefs --schema user.avsc", "# use the \"version\" field as an OCC version:", "... version:version --schema user.avsc"});
    }
}

