/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Formats;
import org.slf4j.Logger;

@Parameters(commandDescription="Create an empty dataset")
public class CreateDatasetCommand
extends BaseDatasetCommand {
    private static final Splitter PROP_VALUE_SEP = Splitter.on((char)'=').limit(2);
    @Parameter(description="<dataset name>")
    List<String> datasets;
    @Parameter(names={"-s", "--schema"}, required=true, description="The file containing the Avro schema.")
    String avroSchemaFile;
    @Parameter(names={"-p", "--partition-by"}, description="The file containing a JSON-formatted partition strategy.")
    String partitionStrategyFile;
    @Parameter(names={"-m", "--mapping"}, description="The file containing a JSON-formatted column mapping.")
    String columnMappingFile;
    @Parameter(names={"-f", "--format"}, description="The file format: avro or parquet.")
    String format = Formats.AVRO.getName();
    @Parameter(names={"--set", "--property"}, description="Add a property pair: prop.name=value")
    List<String> properties;

    public CreateDatasetCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        if (this.datasets == null || this.datasets.size() != 1) {
            throw new IllegalArgumentException("Exactly one dataset name must be specified.");
        }
        DatasetDescriptor.Builder descriptorBuilder = new DatasetDescriptor.Builder();
        if (this.format.equals(Formats.AVRO.getName())) {
            descriptorBuilder.format(Formats.AVRO);
        } else if (this.format.equals(Formats.PARQUET.getName())) {
            descriptorBuilder.format(Formats.PARQUET);
        } else {
            throw new IllegalArgumentException("Unrecognized format: " + this.format);
        }
        descriptorBuilder.schemaUri(this.qualifiedURI(this.avroSchemaFile));
        if (this.partitionStrategyFile != null) {
            descriptorBuilder.partitionStrategyUri(this.qualifiedURI(this.partitionStrategyFile));
        }
        if (this.columnMappingFile != null) {
            descriptorBuilder.columnMappingUri(this.qualifiedURI(this.columnMappingFile));
        }
        if (this.properties != null) {
            for (String propValue : this.properties) {
                Iterator parts = PROP_VALUE_SEP.split((CharSequence)propValue).iterator();
                descriptorBuilder.property((String)Iterators.getNext(parts, null), (String)Iterators.getNext(parts, null));
            }
        }
        DatasetDescriptor descriptor = descriptorBuilder.build();
        if (CreateDatasetCommand.isDatasetOrViewUri(this.datasets.get(0))) {
            Datasets.create((String)this.datasets.get(0), (DatasetDescriptor)descriptor, Object.class);
        } else {
            this.getDatasetRepository().create(this.namespace, this.datasets.get(0), descriptor);
        }
        this.console.debug("Created {}", (Object)this.datasets.get(0));
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Create dataset \"users\" in Hive:", "users --schema user.avsc", "# Create HDFS dataset \"users\":", "dataset:hdfs:/user/me/datasets/users --schema user.avsc", "# Create dataset \"users\" using parquet:", "users --schema user.avsc --format parquet", "# Create dataset \"users\" partitioned by JSON configuration:", "users --schema user.avsc --partition-by email-part.json", "# Create HBase dataset \"users\":", "dataset:hbase:zk1,zk2/users --schema user.avsc \\\n\t\t--partition-by email-part.json --mapping user-cols.json"});
    }
}

