/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.DatasetRepository;
import org.slf4j.Logger;

@Parameters(commandDescription="Delete a view or a dataset and its metadata")
public class DeleteCommand
extends BaseDatasetCommand {
    @Parameter(description="<dataset or view>")
    List<String> targets;

    public DeleteCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        DatasetRepository repo = this.getDatasetRepository();
        if (this.targets == null || this.targets.isEmpty()) {
            throw new IllegalArgumentException("No views or datasets were specified.");
        }
        for (String uriOrName : this.targets) {
            if (DeleteCommand.isViewUri(uriOrName)) {
                View view = Datasets.load((String)uriOrName);
                Preconditions.checkArgument((boolean)DeleteCommand.viewMatches(view.getUri(), uriOrName), (Object)("Resolved view does not match requested view: " + view.getUri()));
                view.deleteAll();
            } else if (DeleteCommand.isDatasetUri(uriOrName)) {
                Datasets.delete((String)uriOrName);
            } else {
                repo.delete(this.namespace, uriOrName);
            }
            this.console.debug("Deleted {}", (Object)uriOrName);
        }
        return 0;
    }

    @VisibleForTesting
    static boolean viewMatches(URI view, String requested) {
        Map<String, String> requestedOptions = DeleteCommand.optionsForUri(URI.create(requested));
        Map<String, String> finalOptions = DeleteCommand.optionsForUri(view);
        for (Map.Entry<String, String> entry : requestedOptions.entrySet()) {
            if (finalOptions.containsKey(entry.getKey()) && finalOptions.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Delete all data and metadata for the dataset \"users\":", "users", "# Delete all records in a view of \"events\":", "view:hive:events?source=m1", "# Delete all data and metadata for a dataset by URI:", "dataset:hbase:zk1,zk2/users"});
    }
}

