/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.spi.ColumnMappingParser;
import org.kitesdk.data.spi.PartitionStrategyParser;
import org.slf4j.Logger;

@Parameters(commandDescription="Print all metadata for a Dataset")
public class InfoCommand
extends BaseDatasetCommand {
    private static final Splitter NEWLINE = Splitter.on((char)'\n');
    private static final Joiner NEWLINE_TAB = Joiner.on((String)"\n\t\t");
    @Parameter(description="<dataset name>")
    List<String> datasets;

    public InfoCommand(Logger console) {
        super(console);
    }

    @Override
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="Null case checked by precondition")
    public int run() throws IOException {
        Preconditions.checkArgument((this.datasets != null && !this.datasets.isEmpty() ? 1 : 0) != 0, (Object)"Missing dataset name");
        for (String name : this.datasets) {
            InfoCommand.printInfo(this.console, this.load(name, GenericRecord.class).getDataset());
        }
        return 0;
    }

    private static void printInfo(Logger console, Dataset<?> dataset) {
        DatasetDescriptor desc = dataset.getDescriptor();
        String schema = ColumnMappingParser.removeEmbeddedMapping((Schema)PartitionStrategyParser.removeEmbeddedStrategy((Schema)desc.getSchema())).toString(true);
        Collection properties = desc.listProperties();
        console.info("\nDataset \"{}\":", (Object)dataset.getName());
        console.info("\tURI: \"{}\"", (Object)dataset.getUri());
        console.info("\tSchema: {}", (Object)InfoCommand.indent(schema));
        if (desc.isPartitioned()) {
            console.info("\tPartition strategy: {}", (Object)InfoCommand.indent(desc.getPartitionStrategy().toString(true)));
        } else {
            console.info("\tNot partitioned");
        }
        if (desc.isColumnMapped()) {
            console.info("\tColumn mapping: {}", (Object)InfoCommand.indent(desc.getColumnMapping().toString(true)));
        }
        if (!properties.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String prop : properties) {
                sb.append("\n\t\t").append(prop).append("=").append(desc.getProperty(prop));
            }
            console.info("\tProperties:{}", (Object)sb.toString());
        }
    }

    private static String indent(String lines) {
        return NEWLINE_TAB.join(NEWLINE.split((CharSequence)lines));
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Print metadata about dataset \"users\":", "users"});
    }
}

