/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.crunch.DoFn;
import org.apache.crunch.PipelineResult;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.compat.DynConstructors;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.ColumnMappingParser;
import org.kitesdk.data.spi.PartitionStrategyParser;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.TemporaryFileSystemDatasetRepository;
import org.kitesdk.tools.CopyTask;
import org.kitesdk.tools.TaskUtil;
import org.kitesdk.tools.TransformTask;
import org.slf4j.Logger;

@Parameters(commandDescription="Copy JSON records into a Dataset")
public class JSONImportCommand
extends BaseDatasetCommand {
    @Parameter(description="<json path> <dataset name>")
    List<String> targets;
    @Parameter(names={"--no-compaction"}, description="Copy to output directly, without compacting the data")
    boolean noCompaction = false;
    @Parameter(names={"--num-writers"}, description="The number of writer processes to use")
    int numWriters = -1;
    @Parameter(names={"--transform"}, description="A transform DoFn class name")
    String transform = null;
    @Parameter(names={"--jar"}, description="Add a jar to the runtime classpath")
    List<String> jars;

    public JSONImportCommand(Logger console) {
        super(console);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.targets != null && this.targets.size() == 2 ? 1 : 0) != 0, (Object)"JSON path and target dataset name are required.");
        Path source = this.qualifiedPath(this.targets.get(0));
        FileSystem sourceFS = source.getFileSystem(this.getConf());
        Preconditions.checkArgument((boolean)sourceFS.exists(source), (Object)("JSON path does not exist: " + source));
        String dataset = this.targets.get(1);
        View<GenericData.Record> target = this.load(dataset, GenericData.Record.class);
        Schema datasetSchema = target.getDataset().getDescriptor().getSchema();
        DatasetDescriptor jsonDescriptor = new DatasetDescriptor.Builder().location(source.toUri()).schema(ColumnMappingParser.removeEmbeddedMapping((Schema)PartitionStrategyParser.removeEmbeddedStrategy((Schema)datasetSchema))).format("json").build();
        TemporaryFileSystemDatasetRepository repo = new TemporaryFileSystemDatasetRepository(this.getConf(), sourceFS.makeQualified(new Path("/tmp")), target.getDataset().getNamespace(), UUID.randomUUID().toString());
        try {
            PipelineResult result;
            TransformTask task;
            FileSystemDataset jsonDataset = (FileSystemDataset)repo.create("import", "json", jsonDescriptor);
            Iterator iter = jsonDataset.pathIterator().iterator();
            Preconditions.checkArgument((boolean)iter.hasNext(), (Object)("JSON path has no data files: " + source));
            TaskUtil.configure(this.getConf()).addJars(this.jars);
            if (this.transform != null) {
                DoFn transformFn;
                try {
                    DynConstructors.Ctor ctor = new DynConstructors.Builder(DoFn.class).loader(JSONImportCommand.loaderForJars(this.jars)).impl(this.transform, new Class[0]).buildChecked();
                    transformFn = (DoFn)ctor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new DatasetException("Cannot find no-arg constructor for class: " + this.transform, (Throwable)e);
                }
                task = new TransformTask(jsonDataset, target, transformFn);
            } else {
                task = new CopyTask<GenericData.Record>((View<GenericData.Record>)jsonDataset, target);
            }
            task.setConf(this.getConf());
            if (this.noCompaction) {
                task.noCompaction();
            }
            if (this.numWriters >= 0) {
                task.setNumWriters(this.numWriters);
            }
            if ((result = task.run()).succeeded()) {
                long count = task.getCount();
                if (count > 0L) {
                    this.console.info("Added {} records to \"{}\"", (Object)count, (Object)dataset);
                }
                int n = 0;
                return n;
            }
            int n = 1;
            return n;
        }
        finally {
            repo.delete();
        }
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Copy the records from sample.json to dataset \"sample\"", "path/to/sample.json sample", "# Copy the records from sample.json to a dataset URI", "path/to/sample.json dataset:hdfs:/user/me/datasets/sample", "# Copy the records from an HDFS directory to \"sample\"", "hdfs:/data/path/samples/ sample"});
    }
}

