/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.SchemaUtil;
import org.slf4j.Logger;

@Parameters(commandDescription="Show the schema for a Dataset")
public class SchemaCommand
extends BaseDatasetCommand {
    @Parameter(description="<dataset name>")
    List<String> datasets;
    @Parameter(names={"-o", "--output"}, description="Save schema avsc to path")
    @SuppressWarnings(value={"UWF_NULL_FIELD"}, justification="Field set by JCommander")
    String outputPath = null;
    @Parameter(names={"--minimize"}, description="Minimize schema file size by eliminating white space")
    boolean minimize = false;
    @Parameter(names={"--merge"}, description="Merge schemas into a single output schema")
    boolean merge = false;

    public SchemaCommand(Logger console) {
        super(console);
    }

    @Override
    @SuppressWarnings(value={"NP_GUARANTEED_DEREF", "NP_NULL_ON_SOME_PATH"}, justification="Null case checked by precondition")
    public int run() throws IOException {
        Preconditions.checkArgument((this.datasets != null && !this.datasets.isEmpty() ? 1 : 0) != 0, (Object)"Missing dataset name");
        if (this.merge || this.datasets.size() == 1) {
            Schema mergedSchema = null;
            for (String uriOrPath : this.datasets) {
                mergedSchema = SchemaCommand.merge(mergedSchema, this.schema(uriOrPath));
            }
            Preconditions.checkNotNull(mergedSchema, (Object)"No valid schema found");
            this.output(mergedSchema.toString(!this.minimize), this.console, this.outputPath);
        } else {
            Preconditions.checkArgument((this.outputPath == null ? 1 : 0) != 0, (Object)"Cannot output multiple schemas to one file");
            for (String name : this.datasets) {
                this.console.info("Dataset \"{}\" schema: {}", (Object)name, (Object)this.schema(name).toString(!this.minimize));
            }
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Print the schema for dataset \"users\" to standard out:", "users", "# Print the schema for a dataset URI to standard out:", "dataset:hbase:zk1,zk2/users", "# Save the schema for dataset \"users\" to user.avsc:", "users -o user.avsc"});
    }

    private Schema schema(String uriOrPath) throws IOException {
        if (!SchemaCommand.isDatasetOrViewUri(uriOrPath) && !Compatibility.isCompatibleName((String)uriOrPath)) {
            return new Schema.Parser().parse(this.open(uriOrPath));
        }
        return this.load(uriOrPath, Object.class).getDataset().getDescriptor().getSchema();
    }

    private static Schema merge(Schema left, Schema right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return SchemaUtil.merge((Schema)left, (Schema)right);
    }
}

