/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Datasets;
import org.slf4j.Logger;

@Parameters(commandDescription="Update the metadata descriptor for dataset")
public class UpdateDatasetCommand
extends BaseDatasetCommand {
    private static final Splitter PROP_VALUE_SEP = Splitter.on((char)'=').limit(2);
    @Parameter(description="<dataset>")
    List<String> datasets;
    @Parameter(names={"-s", "--schema"}, description="The file containing the Avro schema.")
    String avroSchemaFile = null;
    @Parameter(names={"--set", "--property"}, description="Add a property pair: prop.name=value")
    List<String> properties;

    public UpdateDatasetCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        if (this.datasets == null || this.datasets.size() != 1) {
            throw new IllegalArgumentException("Exactly one dataset name must be specified.");
        }
        String dataset = this.datasets.remove(0);
        Dataset currentDataset = this.load(dataset, GenericData.Record.class).getDataset();
        DatasetDescriptor.Builder descriptorBuilder = new DatasetDescriptor.Builder(currentDataset.getDescriptor());
        if (this.avroSchemaFile != null) {
            descriptorBuilder.schemaUri(this.qualifiedURI(this.avroSchemaFile));
        }
        if (this.properties != null) {
            for (String propValue : this.properties) {
                Iterator parts = PROP_VALUE_SEP.split((CharSequence)propValue).iterator();
                descriptorBuilder.property((String)Iterators.getNext(parts, null), (String)Iterators.getNext(parts, null));
            }
        }
        DatasetDescriptor descriptor = descriptorBuilder.build();
        if (UpdateDatasetCommand.isDatasetOrViewUri(dataset)) {
            Datasets.update((String)dataset, (DatasetDescriptor)descriptor, GenericData.Record.class);
        } else {
            this.getDatasetRepository().update(this.namespace, dataset, descriptor);
        }
        this.console.debug("Updated {}", (Object)dataset);
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Update schema for dataset \"users\" in Hive:", "users --schema user.avsc", "# Update HDFS dataset by URI, add property:", "dataset:hdfs:/user/me/datasets/users --set kite.writer.cache-size=20"});
    }
}

