/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.tools;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.tools.JarFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobClasspathHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JobClasspathHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareClasspath(Configuration conf, Path libDir, Class<?> ... classesToInclude) throws Exception {
        String localJarPath;
        FileSystem fs = null;
        ArrayList classList = new ArrayList(Arrays.asList(classesToInclude));
        fs = FileSystem.get((Configuration)conf);
        TreeMap<String, String> jarMd5Map = new TreeMap<String, String>();
        for (Class clazz : classList) {
            if (clazz == null || jarMd5Map.containsKey(localJarPath = JarFinder.getJar(clazz))) continue;
            if (!clazz.getName().startsWith("org.apache.hadoop.")) {
                FileInputStream in = new FileInputStream(localJarPath);
                boolean threw = true;
                try {
                    String md5sum = DigestUtils.md5Hex((InputStream)in);
                    jarMd5Map.put(localJarPath, md5sum);
                    threw = false;
                    continue;
                }
                finally {
                    Closeables.close((Closeable)in, (boolean)threw);
                    continue;
                }
            }
            LOG.info("Ignoring {}, since it looks like it's from Hadoop's core libs", (Object)localJarPath);
        }
        for (Map.Entry entry : jarMd5Map.entrySet()) {
            localJarPath = new Path((String)entry.getKey());
            String jarFilename = localJarPath.getName();
            String localMd5sum = (String)entry.getValue();
            LOG.info("Jar {}. MD5 : [{}]", (Object)localJarPath, (Object)localMd5sum);
            Path remoteJarPath = new Path(libDir, jarFilename);
            Path remoteMd5Path = new Path(libDir, jarFilename + ".md5");
            if (!fs.exists(remoteJarPath) || !fs.exists(remoteMd5Path)) {
                this.copyJarToHDFS(fs, (Path)localJarPath, localMd5sum, remoteJarPath, remoteMd5Path);
            } else {
                FSDataInputStream md5FileStream = null;
                String remoteMd5sum = "";
                try {
                    md5FileStream = fs.open(remoteMd5Path);
                    byte[] md5bytes = new byte[32];
                    if (32 == md5FileStream.read(md5bytes)) {
                        remoteMd5sum = new String(md5bytes, Charsets.UTF_8);
                    }
                }
                finally {
                    if (md5FileStream != null) {
                        md5FileStream.close();
                    }
                }
                if (localMd5sum.equals(remoteMd5sum)) {
                    LOG.info("Jar {} already exists [{}] and md5sum are equals", (Object)jarFilename, (Object)remoteJarPath.toUri().toASCIIString());
                } else {
                    LOG.info("Jar {} already exists [{}] and md5sum are different!", (Object)jarFilename, (Object)remoteJarPath.toUri().toASCIIString());
                    this.copyJarToHDFS(fs, (Path)localJarPath, localMd5sum, remoteJarPath, remoteMd5Path);
                }
            }
            DistributedCache.addFileToClassPath((Path)remoteJarPath, (Configuration)conf, (FileSystem)fs);
        }
        DistributedCache.createSymlink((Configuration)conf);
    }

    private void copyJarToHDFS(FileSystem fs, Path localJarPath, String md5sum, Path remoteJarPath, Path remoteMd5Path) throws IOException {
        LOG.info("Copying {} to {}", (Object)localJarPath.toUri().toASCIIString(), (Object)remoteJarPath.toUri().toASCIIString());
        fs.copyFromLocalFile(localJarPath, remoteJarPath);
        this.createMd5SumFile(fs, md5sum, remoteMd5Path);
        if (remoteJarPath.getName().startsWith("tmp__hadoop-")) {
            fs.deleteOnExit(remoteJarPath);
        }
        if (remoteMd5Path.getName().startsWith("tmp__hadoop-")) {
            fs.deleteOnExit(remoteMd5Path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMd5SumFile(FileSystem fs, String md5sum, Path remoteMd5Path) throws IOException {
        FSDataOutputStream os = null;
        try {
            os = fs.create(remoteMd5Path, true);
            os.writeBytes(md5sum);
            os.flush();
        }
        catch (Exception e) {
            LOG.error("{}", (Throwable)e);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }
}

