/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.TestHelpers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestBaseCommand {
    private Logger console = null;
    private BaseDatasetCommand command = null;

    @Before
    public void createCommand() {
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new TestCommand(this.console);
    }

    @Test
    public void testDefaults() {
        Assert.assertEquals((Object)"repo:hive", (Object)this.command.buildRepoURI());
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:hive"));
    }

    @Test
    public void testManagedHiveRepo() {
        this.command.hive = true;
        this.command.directory = null;
        Assert.assertEquals((Object)"repo:hive", (Object)this.command.buildRepoURI());
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:hive"));
    }

    @Test
    public void testExternalHiveRepo() {
        this.command.hive = true;
        this.command.directory = "/tmp/data";
        Assert.assertEquals((Object)"repo:hive:/tmp/data", (Object)this.command.buildRepoURI());
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:hive:/tmp/data"));
    }

    @Test
    public void testRelativeExternalHiveRepo() {
        this.command.hive = true;
        this.command.directory = "data";
        Assert.assertEquals((Object)"repo:hive:data", (Object)this.command.buildRepoURI());
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:hive:data"));
    }

    @Test
    public void testHDFSRepo() {
        this.command.hdfs = true;
        this.command.directory = "/tmp/data";
        Assert.assertEquals((Object)"repo:hdfs:/tmp/data", (Object)this.command.buildRepoURI());
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:hdfs:/tmp/data"));
    }

    @Test
    public void testHDFSRepoRejectsNullPath() {
        this.command.hdfs = true;
        this.command.directory = null;
        TestHelpers.assertThrows((String)"Should reject null directory for HDFS", IllegalArgumentException.class, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestBaseCommand.this.command.buildRepoURI();
            }
        });
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testLocalRepo() {
        this.command.local = true;
        this.command.directory = "/tmp/data";
        Assert.assertEquals((Object)"repo:file:/tmp/data", (Object)this.command.buildRepoURI());
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:/tmp/data"));
    }

    @Test
    public void testLocalDataset() {
        this.command.local = true;
        this.command.directory = "/tmp/data";
        this.command.namespace = "ns";
        Assert.assertEquals((Object)"dataset:file:/tmp/data/ns/users", (Object)this.command.buildDatasetUri("users"));
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:file:/tmp/data"));
    }

    @Test
    public void testLocalRepoRejectsNullPath() {
        this.command.hive = false;
        this.command.local = true;
        this.command.directory = null;
        TestHelpers.assertThrows((String)"Should reject null directory for local", IllegalArgumentException.class, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestBaseCommand.this.command.buildRepoURI();
            }
        });
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testHBaseRepo() {
        this.command.hbase = true;
        this.command.zookeeper = Lists.newArrayList((Object[])new String[]{"zk1:1234", "zk2"});
        Assert.assertEquals((Object)"repo:hbase:zk1:1234,zk2", (Object)this.command.buildRepoURI());
        ((Logger)Mockito.verify((Object)this.console)).trace(Mockito.contains((String)"repo:hbase:zk1:1234,zk2"));
    }

    @Test
    public void testHbaseRepoRejectsNullZooKeeper() {
        this.command.hive = false;
        this.command.local = true;
        this.command.directory = null;
        TestHelpers.assertThrows((String)"Should reject null ZooKeeper for local, non-Hive", IllegalArgumentException.class, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestBaseCommand.this.command.buildRepoURI();
            }
        });
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testRejectsMultipleStorageSchemes() {
        this.command.hive = true;
        this.command.local = true;
        TestHelpers.assertThrows((String)"Should reject multiple storage: Hive and local", IllegalArgumentException.class, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestBaseCommand.this.command.buildRepoURI();
            }
        });
        this.command.local = false;
        this.command.hdfs = true;
        TestHelpers.assertThrows((String)"Should reject multiple storage: Hive and HDFS", IllegalArgumentException.class, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestBaseCommand.this.command.buildRepoURI();
            }
        });
        this.command.hdfs = false;
        this.command.hbase = true;
        TestHelpers.assertThrows((String)"Should reject multiple storage: Hive and HBase", IllegalArgumentException.class, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestBaseCommand.this.command.buildRepoURI();
            }
        });
        this.command.hive = false;
        this.command.local = true;
        TestHelpers.assertThrows((String)"Should reject multiple storage: HBase and local", IllegalArgumentException.class, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestBaseCommand.this.command.buildRepoURI();
            }
        });
        this.command.local = false;
        this.command.hdfs = true;
        TestHelpers.assertThrows((String)"Should reject multiple storage: HBase and HDFS", IllegalArgumentException.class, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestBaseCommand.this.command.buildRepoURI();
            }
        });
        this.command.hbase = false;
        this.command.local = true;
        TestHelpers.assertThrows((String)"Should reject multiple storage: HDFS and local", IllegalArgumentException.class, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestBaseCommand.this.command.buildRepoURI();
            }
        });
    }

    public static class TestCommand
    extends BaseDatasetCommand {
        public TestCommand(Logger console) {
            super(console);
        }

        public int run() throws IOException {
            return 0;
        }

        public List<String> getExamples() {
            return null;
        }
    }
}

