/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Iterators;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.CSVSchemaCommand;
import org.kitesdk.cli.commands.CompactCommand;
import org.kitesdk.compat.DynMethods;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.spi.DatasetRepositories;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestCompactCommandCluster
extends MiniDFSTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    private static final String unpartitioned = "users_source";
    private static final String partitioned = "users_source_partitioned";
    private static final String avsc = "target/user.avsc";
    private static String repoUri;
    private int numRecords;
    private Logger console;
    private CompactCommand command;

    @Before
    public void createDatasets() throws Exception {
        repoUri = "hdfs://" + TestCompactCommandCluster.getDFS().getUri().getAuthority() + "/tmp/data";
        TestUtil.run("delete", unpartitioned, "-r", repoUri, "-d", "target/data");
        File csvFile = this.temp.newFile("users.csv");
        csvFile.delete();
        String csv = csvFile.toString();
        BufferedWriter writer = Files.newWriter((File)csvFile, (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        this.numRecords = 30;
        for (int i = 0; i < this.numRecords; ++i) {
            writer.append(i + ",test" + i + ",test" + i + "@example.com\n");
        }
        writer.close();
        TestUtil.run("-v", "csv-schema", csv, "-o", avsc, "--class", "User");
        TestUtil.run("create", unpartitioned, "-s", avsc, "-r", repoUri, "-d", "target/data");
        URI dsUri = URIBuilder.build((String)("repo:" + repoUri), (String)"default", (String)partitioned);
        Datasets.create((URI)dsUri, (DatasetDescriptor)new DatasetDescriptor.Builder().partitionStrategy(new PartitionStrategy.Builder().hash("id", 2).build()).schema((Schema)SchemaBuilder.record((String)"User").fields().requiredLong("id").optionalString("username").optionalString("email").endRecord()).build(), Object.class);
        TestUtil.run("csv-import", csv, unpartitioned, "-r", repoUri, "-d", "target/data");
        TestUtil.run("csv-import", csv, partitioned, "-r", repoUri, "-d", "target/data");
    }

    @Before
    public void createCommand() {
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new CompactCommand(this.console);
        this.command.setConf(new Configuration());
    }

    @After
    public void deleteSourceDatasets() throws Exception {
        TestUtil.run("delete", unpartitioned, "-r", repoUri, "-d", "target/data");
        TestUtil.run("delete", partitioned, "-r", repoUri, "-d", "target/data");
    }

    @Test
    public void testBasicUnpartitionedCompact() throws Exception {
        this.command.repoURI = repoUri;
        this.command.datasets = Lists.newArrayList((Object[])new String[]{unpartitioned});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:" + repoUri));
        int size = Iterators.size((Iterator)repo.load("default", unpartitioned).newReader());
        Assert.assertEquals((String)"Should contain copied records", (long)this.numRecords, (long)size);
        ((Logger)Mockito.verify((Object)this.console)).info("Compacted {} records in \"{}\"", (Object)this.numRecords, (Object)unpartitioned);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCompactUnpartitionedWithNumWriters() throws Exception {
        Assume.assumeTrue((boolean)this.setLocalReducerMax(TestCompactCommandCluster.getConfiguration(), 3));
        this.command.repoURI = repoUri;
        this.command.numWriters = 3;
        this.command.datasets = Lists.newArrayList((Object[])new String[]{unpartitioned});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:" + repoUri));
        FileSystemDataset ds = (FileSystemDataset)repo.load("default", unpartitioned);
        int size = Iterators.size((Iterator)ds.newReader());
        Assert.assertEquals((String)"Should contain copied records", (long)this.numRecords, (long)size);
        Assert.assertEquals((String)"Should produce 3 files", (long)3L, (long)Iterators.size((Iterator)ds.pathIterator()));
        ((Logger)Mockito.verify((Object)this.console)).info("Compacted {} records in \"{}\"", (Object)this.numRecords, (Object)unpartitioned);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCompactUnpartitionedWithNumPartitionWriters() throws Exception {
        Assume.assumeTrue((boolean)this.setLocalReducerMax(TestCompactCommandCluster.getConfiguration(), 3));
        this.command.repoURI = repoUri;
        this.command.numWriters = 3;
        this.command.filesPerPartition = 4;
        this.command.datasets = Lists.newArrayList((Object[])new String[]{unpartitioned});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:" + repoUri));
        FileSystemDataset ds = (FileSystemDataset)repo.load("default", unpartitioned);
        int size = Iterators.size((Iterator)ds.newReader());
        Assert.assertEquals((String)"Should contain copied records", (long)this.numRecords, (long)size);
        Assert.assertEquals((String)"Should produce 3 files", (long)3L, (long)Iterators.size((Iterator)ds.pathIterator()));
        ((Logger)Mockito.verify((Object)this.console)).info("Compacted {} records in \"{}\"", (Object)this.numRecords, (Object)unpartitioned);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testPartitionedCompactWithNumWriters() throws Exception {
        Assume.assumeTrue((boolean)this.setLocalReducerMax(TestCompactCommandCluster.getConfiguration(), 2));
        this.command.repoURI = repoUri;
        this.command.numWriters = 2;
        this.command.filesPerPartition = 1;
        this.command.datasets = Lists.newArrayList((Object[])new String[]{partitioned});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:" + repoUri));
        FileSystemDataset ds = (FileSystemDataset)repo.load("default", partitioned);
        int size = Iterators.size((Iterator)ds.newReader());
        Assert.assertEquals((String)"Should contain copied records", (long)this.numRecords, (long)size);
        Assert.assertEquals((String)"Should produce 2 partitions", (long)2L, (long)Iterators.size(ds.getCoveringPartitions().iterator()));
        Assert.assertEquals((String)("Should produce 2 files: " + Iterators.toString((Iterator)ds.pathIterator())), (long)2L, (long)Iterators.size((Iterator)ds.pathIterator()));
        ((Logger)Mockito.verify((Object)this.console)).info("Compacted {} records in \"{}\"", (Object)this.numRecords, (Object)partitioned);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testPartitionedCompactWithNumWritersNumFilesPerPartition() throws Exception {
        Assume.assumeTrue((boolean)this.setLocalReducerMax(TestCompactCommandCluster.getConfiguration(), 2));
        this.command.repoURI = repoUri;
        this.command.numWriters = 10;
        this.command.filesPerPartition = 3;
        this.command.datasets = Lists.newArrayList((Object[])new String[]{partitioned});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:" + repoUri));
        FileSystemDataset ds = (FileSystemDataset)repo.load("default", partitioned);
        int size = Iterators.size((Iterator)ds.newReader());
        Assert.assertEquals((String)"Should contain copied records", (long)this.numRecords, (long)size);
        Assert.assertEquals((String)"Should produce 2 partitions", (long)2L, (long)Iterators.size(ds.getCoveringPartitions().iterator()));
        Assert.assertEquals((String)"Should produce 6 files", (long)6L, (long)Iterators.size((Iterator)ds.pathIterator()));
        ((Logger)Mockito.verify((Object)this.console)).info("Compacted {} records in \"{}\"", (Object)this.numRecords, (Object)partitioned);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    private boolean setLocalReducerMax(Configuration conf, int max) {
        try {
            Job job = (Job)Hadoop.Job.newInstance.invoke(new Object[]{new Configuration(false)});
            DynMethods.StaticMethod setReducerMax = new DynMethods.Builder("setLocalMaxRunningReduces").impl(LocalJobRunner.class, new Class[]{JobContext.class, Integer.TYPE}).buildStaticChecked();
            setReducerMax.invoke(new Object[]{job, max});
            Configuration jobConf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)job, new Object[0]);
            for (Map.Entry entry : jobConf) {
                conf.set((String)entry.getKey(), (String)entry.getValue());
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

