/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Iterators;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.CSVSchemaCommand;
import org.kitesdk.cli.commands.CopyCommand;
import org.kitesdk.compat.DynMethods;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.spi.DatasetRepositories;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestCopyCommandCluster
extends MiniDFSTest {
    protected static final String source = "users_source";
    protected static final String dest = "users_dest";
    protected static final String dest_partitioned = "users_dest_partitioned";
    protected static final String avsc = "target/user.avsc";
    protected static String repoUri;
    protected Logger console;
    protected CopyCommand command;

    @BeforeClass
    public static void createSourceDataset() throws Exception {
        repoUri = "hdfs://" + TestCopyCommandCluster.getDFS().getUri().getAuthority() + "/tmp/data";
        TestUtil.run("delete", source, "-r", repoUri, "-d", "target/data");
        String csv = "/tmp/users.csv";
        BufferedWriter writer = Files.newWriter((File)new File(csv), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        writer.append("1,test,test@example.com\n");
        writer.append("2,user,user@example.com\n");
        writer.append("3,user3,user3@example.com\n");
        writer.append("4,user4,user4@example.com\n");
        writer.append("5,user5,user5@example.com\n");
        writer.append("6,user6,user6@example.com\n");
        writer.close();
        TestUtil.run("-v", "csv-schema", csv, "-o", avsc, "--class", "User", "--require", "id");
        TestUtil.run("create", source, "-s", avsc, "-r", repoUri, "-d", "target/data");
        TestUtil.run("csv-import", csv, source, "-r", repoUri, "-d", "target/data");
    }

    @AfterClass
    public static void deleteSourceDataset() throws Exception {
        TestUtil.run("delete", source, "-r", repoUri, "-d", "target/data");
    }

    @Before
    public void createDestination() throws Exception {
        TestUtil.run("delete", dest, "-r", repoUri, "-d", "target/data");
        TestUtil.run("create", dest, "-s", avsc, "-r", repoUri, "-d", "target/data");
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new CopyCommand(this.console);
        this.command.setConf(new Configuration());
    }

    @After
    public void deleteDestination() throws Exception {
        TestUtil.run("delete", dest, "-r", repoUri, "-d", "target/data");
        TestUtil.run("delete", dest_partitioned, "-r", repoUri, "-d", "target/data");
    }

    @Test
    public void testBasicCopy() throws Exception {
        this.command.repoURI = repoUri;
        this.command.datasets = Lists.newArrayList((Object[])new String[]{source, dest});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:" + repoUri));
        int size = Iterators.size((Iterator)repo.load("default", dest).newReader());
        Assert.assertEquals((String)"Should contain copied records", (long)6L, (long)size);
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)6L, (Object)dest);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCopyWithoutCompaction() throws Exception {
        this.testCopyWithoutCompaction(1);
    }

    public void testCopyWithoutCompaction(int expectedFiles) throws Exception {
        this.command.repoURI = repoUri;
        this.command.noCompaction = true;
        this.command.datasets = Lists.newArrayList((Object[])new String[]{source, dest});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:" + repoUri));
        FileSystemDataset ds = (FileSystemDataset)repo.load("default", dest);
        int size = Iterators.size((Iterator)ds.newReader());
        Assert.assertEquals((String)"Should contain copied records", (long)6L, (long)size);
        Object[] paths = (Path[])Iterators.toArray((Iterator)ds.pathIterator(), Path.class);
        Assert.assertEquals((String)("Should produce " + expectedFiles + " files: " + Arrays.toString(paths)), (long)expectedFiles, (long)Iterators.size((Iterator)ds.pathIterator()));
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)6L, (Object)dest);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCopyWithNumWriters() throws Exception {
        this.testCopyWithNumWriters(3);
    }

    public void testCopyWithNumWriters(int expectedFiles) throws Exception {
        Assume.assumeTrue((boolean)this.setLocalReducerMax(TestCopyCommandCluster.getConfiguration(), 3));
        this.command.repoURI = repoUri;
        this.command.numWriters = 3;
        this.command.datasets = Lists.newArrayList((Object[])new String[]{source, dest});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:" + repoUri));
        FileSystemDataset ds = (FileSystemDataset)repo.load("default", dest);
        int size = Iterators.size((Iterator)ds.newReader());
        Assert.assertEquals((String)"Should contain copied records", (long)6L, (long)size);
        Assert.assertEquals((String)("Should produce " + expectedFiles + " files"), (long)expectedFiles, (long)Iterators.size((Iterator)ds.pathIterator()));
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)6L, (Object)dest);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    @Test
    public void testCopyWithNumPartitionWriters() throws Exception {
        this.testCopyWithNumPartitionWriters(3, 4, 3);
    }

    public void testCopyWithNumPartitionWriters(int numWriters, int filesPerPartition, int expectedFiles) throws IOException {
        Assume.assumeTrue((boolean)this.setLocalReducerMax(TestCopyCommandCluster.getConfiguration(), numWriters));
        this.command.repoURI = repoUri;
        this.command.numWriters = numWriters;
        this.command.filesPerPartition = filesPerPartition;
        this.command.datasets = Lists.newArrayList((Object[])new String[]{source, dest});
        int rc = this.command.run();
        Assert.assertEquals((String)"Should return success", (long)0L, (long)rc);
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:" + repoUri));
        FileSystemDataset ds = (FileSystemDataset)repo.load("default", dest);
        int size = Iterators.size((Iterator)ds.newReader());
        Assert.assertEquals((String)"Should contain copied records", (long)6L, (long)size);
        Assert.assertEquals((String)("Should produce " + expectedFiles + " files"), (long)expectedFiles, (long)Iterators.size((Iterator)ds.pathIterator()));
        ((Logger)Mockito.verify((Object)this.console)).info("Added {} records to \"{}\"", (Object)6L, (Object)dest);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
    }

    private boolean setLocalReducerMax(Configuration conf, int max) {
        try {
            Job job = (Job)Hadoop.Job.newInstance.invoke(new Object[]{new Configuration(false)});
            DynMethods.StaticMethod setReducerMax = new DynMethods.Builder("setLocalMaxRunningReduces").impl(LocalJobRunner.class, new Class[]{JobContext.class, Integer.TYPE}).buildStaticChecked();
            setReducerMax.invoke(new Object[]{job, max});
            Configuration jobConf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)job, new Object[0]);
            for (Map.Entry entry : jobConf) {
                conf.set((String)entry.getKey(), (String)entry.getValue());
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

