/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import com.google.common.collect.ImmutableList;
import java.io.FileOutputStream;
import java.util.List;
import org.apache.avro.Schema;
import org.kitesdk.cli.commands.TestCopyCommandClusterSchemaEvolution;
import org.kitesdk.data.PartitionStrategy;

public class TestCopyCommandClusterChangedNameWithPartitioning
extends TestCopyCommandClusterSchemaEvolution {
    private static final String partitionStrategyJson = "target/partition-strategy.json";

    @Override
    public Schema getEvolvedSchema(Schema original) {
        List fields = Lists.newArrayList();
        for (Schema.Field field : original.getFields()) {
            fields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue()));
        }
        Schema evolved = Schema.createRecord((String)"NewUser", (String)original.getDoc(), (String)original.getNamespace(), (boolean)false);
        evolved.addAlias("User");
        evolved.setFields(fields);
        return evolved;
    }

    @Override
    public List<String> getExtraCreateArgs() throws Exception {
        PartitionStrategy partitionStrategy = new PartitionStrategy.Builder().hash("id", "part", 2).build();
        FileOutputStream psOut = new FileOutputStream(partitionStrategyJson);
        psOut.write(partitionStrategy.toString(true).getBytes());
        psOut.close();
        return ImmutableList.of((Object)"-p", (Object)partitionStrategyJson, (Object)"--set", (Object)"kite.writer.cache-size=20");
    }

    @Override
    public void testCopyWithoutCompaction() throws Exception {
        this.testCopyWithoutCompaction(2);
    }

    @Override
    public void testCopyWithNumWriters() throws Exception {
        this.testCopyWithNumWriters(2);
    }

    @Override
    public void testCopyWithNumPartitionWriters() throws Exception {
        this.testCopyWithNumPartitionWriters(10, 3, 6);
    }
}

