/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.CopyCommand;
import org.kitesdk.cli.commands.TestCopyCommandCluster;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestCopyCommandClusterSchemaEvolution
extends TestCopyCommandCluster {
    private static final String evolvedAvsc = "target/evolved_user.avsc";

    @Override
    public void createDestination() throws Exception {
        FileInputStream schemaIn = new FileInputStream("target/user.avsc");
        Schema original = new Schema.Parser().parse((InputStream)schemaIn);
        schemaIn.close();
        Schema evolved = this.getEvolvedSchema(original);
        FileOutputStream schemaOut = new FileOutputStream(evolvedAvsc);
        schemaOut.write(evolved.toString(true).getBytes());
        schemaOut.close();
        ArrayList createArgs = Lists.newArrayList((Object[])new String[]{"create", "users_dest", "-s", evolvedAvsc, "-r", repoUri, "-d", "target/data"});
        createArgs.addAll(this.getExtraCreateArgs());
        TestUtil.run(LoggerFactory.getLogger(((Object)((Object)this)).getClass()), "delete", "users_dest", "-r", repoUri, "-d", "target/data");
        TestUtil.run(LoggerFactory.getLogger(((Object)((Object)this)).getClass()), createArgs.toArray(new String[createArgs.size()]));
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new CopyCommand(this.console);
        this.command.setConf(new Configuration());
    }

    public abstract Schema getEvolvedSchema(Schema var1) throws Exception;

    public abstract List<String> getExtraCreateArgs() throws Exception;
}

