/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Resources;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.commands.CreateDatasetCommand;
import org.kitesdk.cli.example.User;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.data.spi.OptionBuilder;
import org.kitesdk.data.spi.Registration;
import org.kitesdk.data.spi.URIPattern;
import org.kitesdk.data.spi.hive.MetaStoreUtil;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestCreateDatasetCommandCluster
extends MiniDFSTest {
    private static final AtomicInteger ids = new AtomicInteger(0);
    private static final Map<String, DatasetRepository> repos = Maps.newHashMap();
    private String id = null;
    private CreateDatasetCommand command = null;
    private Logger console;

    @BeforeClass
    public static void addMockRepoBuilder() throws Exception {
        Registration.register((URIPattern)new URIPattern("mock::id"), (URIPattern)new URIPattern("mock::id"), (OptionBuilder)new OptionBuilder<DatasetRepository>(){

            public DatasetRepository getFromOptions(Map<String, String> options) {
                DatasetRepository repo = (DatasetRepository)Mockito.mock(DatasetRepository.class);
                repos.put(options.get("id"), repo);
                return repo;
            }
        });
    }

    @Before
    public void setUp() {
        this.id = Integer.toString(ids.addAndGet(1));
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new CreateDatasetCommand(this.console);
        this.command.setConf(TestCreateDatasetCommandCluster.getConfiguration());
        this.command.repoURI = "repo:mock:" + this.id;
    }

    public DatasetRepository getMockRepo() {
        return repos.get(this.id);
    }

    @Test
    public void testBasicUse() throws Exception {
        this.command.avroSchemaFile = "resource:test-schemas/user.avsc";
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.run();
        DatasetDescriptor expectedDescriptor = new DatasetDescriptor.Builder().schemaUri("resource:test-schemas/user.avsc").build();
        ((DatasetRepository)Mockito.verify((Object)this.getMockRepo())).create("default", "users", expectedDescriptor);
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Created"), Mockito.eq((Object)"users"));
    }

    @Test
    public void testBasicUseLocalSchema() throws Exception {
        String avsc = "target/localUser.avsc";
        FSDataOutputStream out = TestCreateDatasetCommandCluster.getFS().create(new Path(avsc), true);
        ByteStreams.copy((InputStream)Resources.getResource((String)"test-schemas/user.avsc").openStream(), (OutputStream)out);
        out.close();
        this.command.avroSchemaFile = avsc;
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.run();
        DatasetDescriptor expectedDescriptor = new DatasetDescriptor.Builder().schemaUri("resource:test-schemas/user.avsc").build();
        ((DatasetRepository)Mockito.verify((Object)this.getMockRepo())).create("default", "users", expectedDescriptor);
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Created"), Mockito.eq((Object)"users"));
    }

    @Test
    public void testBasicUseHDFSSchema() throws Exception {
        Configuration existing = DefaultConfiguration.get();
        DefaultConfiguration.set((Configuration)TestCreateDatasetCommandCluster.getConfiguration());
        String avsc = "hdfs:/tmp/schemas/hdfsUser.avsc";
        FSDataOutputStream out = TestCreateDatasetCommandCluster.getDFS().create(new Path(avsc), true);
        ByteStreams.copy((InputStream)Resources.getResource((String)"test-schemas/user.avsc").openStream(), (OutputStream)out);
        out.close();
        this.command.avroSchemaFile = avsc;
        this.command.datasets = Lists.newArrayList((Object[])new String[]{"users"});
        this.command.run();
        DatasetDescriptor expectedDescriptor = new DatasetDescriptor.Builder().schemaUri("resource:test-schemas/user.avsc").build();
        ((DatasetRepository)Mockito.verify((Object)this.getMockRepo())).create("default", "users", expectedDescriptor);
        ((Logger)Mockito.verify((Object)this.console)).debug(Mockito.contains((String)"Created"), Mockito.eq((Object)"users"));
        DefaultConfiguration.set((Configuration)existing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateWithExistingDataPartitions() throws IOException {
        Configuration existing = DefaultConfiguration.get();
        try {
            DefaultConfiguration.set((Configuration)TestCreateDatasetCommandCluster.getConfiguration());
            DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(User.class).partitionStrategy(new PartitionStrategy.Builder().hash("username", 4).build()).build();
            Dataset users = (Dataset)Datasets.create((String)"dataset:hdfs:/tmp/datasets/users", (DatasetDescriptor)descriptor, User.class);
            DatasetWriter writer = null;
            try {
                writer = users.newWriter();
                writer.write((Object)new User("test", "test@example.com"));
            }
            finally {
                Closeables.closeQuietly((Closeable)writer);
            }
            TestCreateDatasetCommandCluster.getDFS().delete(new Path("/tmp/datasets/users/.metadata"), true);
            Logger console = (Logger)Mockito.mock(Logger.class);
            CreateDatasetCommand create = new CreateDatasetCommand(console);
            create.setConf(TestCreateDatasetCommandCluster.getConfiguration());
            create.datasets = Lists.newArrayList((Object[])new String[]{"dataset:hive:users"});
            create.location = "hdfs:/tmp/datasets/users";
            create.run();
            Dataset loaded = (Dataset)Datasets.load((String)"dataset:hive:users");
            Assert.assertNotNull((String)"Should successfully create Hive dataset", (Object)loaded);
            Assert.assertTrue((String)"Should be partitioned", (boolean)loaded.getDescriptor().isPartitioned());
            PartitionStrategy expectedStrategy = new PartitionStrategy.Builder().provided("username_hash", "int").build();
            Assert.assertEquals((String)"Should have a provided partition strategy", (Object)expectedStrategy, (Object)loaded.getDescriptor().getPartitionStrategy());
            MetaStoreUtil meta = new MetaStoreUtil(TestCreateDatasetCommandCluster.getConfiguration());
            List partitions = meta.listPartitions("default", "users", (short)10);
            Assert.assertEquals((String)"Table should have a partition", (long)1L, (long)partitions.size());
            Assert.assertTrue((String)"Partition should exist", (boolean)TestCreateDatasetCommandCluster.getDFS().exists(new Path((String)partitions.get(0))));
            Assert.assertTrue((String)"Partition should be a partition directory", (boolean)((String)partitions.get(0)).contains("/tmp/datasets/users/username_hash="));
        }
        finally {
            Datasets.delete((String)"dataset:hive:users");
            DefaultConfiguration.set((Configuration)existing);
        }
    }
}

