/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.internal.Lists;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.cli.TestUtil;
import org.kitesdk.cli.commands.CSVSchemaCommand;
import org.kitesdk.cli.commands.CreateDatasetCommand;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetExistsException;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Formats;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.Schemas;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestCreateDatasetWithExistingData {
    private static final Path existingDataPath = new Path("target/data/users_parquet");
    private static final String existingDataURI = "dataset:file:target/data/users_parquet";
    private static final Path existingPartitionedPath = new Path("target/data/users_partitioned");
    private static final Path existingPartitionedPathWithPartition = new Path("target/data/users_partitioned/version=1");
    private static final String existingPartitionedURI = "dataset:file:target/data/users_partitioned";
    private static final String sourceDatasetURI = "dataset:file:target/data/users";
    private static Schema USER_SCHEMA;
    private CreateDatasetCommand command = null;
    private Logger console;

    @BeforeClass
    public static void createDatasetFromCSV() throws Exception {
        String sample = "target/users.csv";
        String avsc = "target/user.avsc";
        BufferedWriter writer = Files.newWriter((File)new File(sample), (Charset)CSVSchemaCommand.SCHEMA_CHARSET);
        writer.append("id,username,email\n");
        writer.append("1,test,test@example.com\n");
        writer.append("2,user,user@example.com\n");
        writer.close();
        TestUtil.run("delete", sourceDatasetURI);
        TestUtil.run("-v", "csv-schema", sample, "-o", avsc, "--class", "User");
        TestUtil.run("-v", "create", sourceDatasetURI, "-s", avsc, "-f", "parquet");
        TestUtil.run("-v", "csv-import", sample, sourceDatasetURI);
        USER_SCHEMA = Schemas.fromAvsc((File)new File(avsc));
        FileSystem fs = LocalFileSystem.getInstance();
        FileStatus[] stats = fs.listStatus(new Path("target/data/users"));
        Path parquetFile = null;
        for (FileStatus stat : stats) {
            if (!stat.getPath().toString().endsWith(".parquet")) continue;
            parquetFile = stat.getPath();
            break;
        }
        fs.mkdirs(existingDataPath);
        fs.copyFromLocalFile(parquetFile, existingDataPath);
        fs.mkdirs(existingPartitionedPathWithPartition);
        fs.copyFromLocalFile(parquetFile, existingPartitionedPathWithPartition);
    }

    @AfterClass
    public static void removeData() throws Exception {
        TestUtil.run("delete", sourceDatasetURI);
        FileSystem fs = LocalFileSystem.getInstance();
        fs.delete(existingDataPath, true);
        fs.delete(existingPartitionedPath, true);
    }

    @Before
    public void setup() throws Exception {
        this.console = (Logger)Mockito.mock(Logger.class);
        this.command = new CreateDatasetCommand(this.console);
        this.command.setConf(new Configuration());
    }

    @After
    public void removeMetadata() throws Exception {
        FileSystem fs = LocalFileSystem.getInstance();
        fs.delete(new Path(existingDataPath, ".metadata"), true);
        fs.delete(new Path(existingPartitionedPath, ".metadata"), true);
    }

    @Test
    public void testCreateFromExisting() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{existingDataURI});
        this.command.run();
        ((Logger)Mockito.verify((Object)this.console)).debug(Matchers.contains((String)"Created"), Matchers.eq((Object)existingDataURI));
        Dataset users = (Dataset)Datasets.load((String)existingDataURI);
        Assert.assertEquals((String)"Schema should match", (Object)USER_SCHEMA, (Object)users.getDescriptor().getSchema());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)users.getDescriptor().isPartitioned());
        Assert.assertEquals((String)"Should be Parquet", (Object)Formats.PARQUET, (Object)users.getDescriptor().getFormat());
    }

    @Test
    public void testCreateFromExistingWithLocation() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{existingDataURI});
        this.command.location = existingPartitionedPathWithPartition.toString();
        this.command.run();
        ((Logger)Mockito.verify((Object)this.console)).debug(Matchers.contains((String)"Created"), Matchers.eq((Object)existingDataURI));
        Dataset users = (Dataset)Datasets.load((String)existingDataURI);
        Assert.assertEquals((String)"Schema should match", (Object)USER_SCHEMA, (Object)users.getDescriptor().getSchema());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)users.getDescriptor().isPartitioned());
        Assert.assertEquals((String)"Should be Parquet", (Object)Formats.PARQUET, (Object)users.getDescriptor().getFormat());
        Assert.assertTrue((String)"Location should point to the partitioned data", (boolean)String.valueOf(users.getDescriptor().getLocation()).endsWith(existingPartitionedPathWithPartition.toString()));
    }

    @Test
    public void testFailCreateFormatMismatch() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{existingDataURI});
        this.command.format = "avro";
        TestHelpers.assertThrows((String)"Should reject Avro format when Parquet data exists", ValidationException.class, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                TestCreateDatasetWithExistingData.this.command.run();
                return null;
            }
        });
    }

    @Test
    public void testFailCreateSchemaCannotReadExisting() throws Exception {
        Schema requiresId = (Schema)SchemaBuilder.record((String)"User").fields().requiredLong("id").optionalString("username").optionalString("email").endRecord();
        File avsc = new File("target/user_requires_id.avsc");
        FileWriter writer = new FileWriter(avsc);
        writer.append(requiresId.toString());
        writer.close();
        this.command.datasets = Lists.newArrayList((Object[])new String[]{existingDataURI});
        this.command.avroSchemaFile = avsc.toString();
        TestHelpers.assertThrows((String)"Should reject incompatible schema", ValidationException.class, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                TestCreateDatasetWithExistingData.this.command.run();
                return null;
            }
        });
        Assert.assertTrue((boolean)avsc.delete());
    }

    @Test
    public void testFailCreateIfDatasetExists() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{sourceDatasetURI});
        TestHelpers.assertThrows((String)"Should fail because the dataset already exists", DatasetExistsException.class, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                TestCreateDatasetWithExistingData.this.command.run();
                return null;
            }
        });
    }

    @Test
    public void testCreateFromExistingPartitioned() throws Exception {
        this.command.datasets = Lists.newArrayList((Object[])new String[]{existingPartitionedURI});
        this.command.run();
        ((Logger)Mockito.verify((Object)this.console)).debug(Matchers.contains((String)"Created"), Matchers.eq((Object)existingPartitionedURI));
        PartitionStrategy providedVersionStrategy = new PartitionStrategy.Builder().provided("version", "int").build();
        Dataset users = (Dataset)Datasets.load((String)existingPartitionedURI);
        Assert.assertEquals((String)"Schema should match", (Object)USER_SCHEMA, (Object)users.getDescriptor().getSchema());
        Assert.assertEquals((String)"Should be partitioned with a provided partitioner", (Object)providedVersionStrategy, (Object)users.getDescriptor().getPartitionStrategy());
        Assert.assertEquals((String)"Should be Parquet", (Object)Formats.PARQUET, (Object)users.getDescriptor().getFormat());
    }

    @Test
    public void testFailIncompatiblePartitionStrategy() throws Exception {
        PartitionStrategy versionStrategy = new PartitionStrategy.Builder().year("id").build();
        File strategy = new File("target/strategy.json");
        FileWriter writer = new FileWriter(strategy);
        writer.append(versionStrategy.toString());
        writer.close();
        this.command.datasets = Lists.newArrayList((Object[])new String[]{existingPartitionedURI});
        this.command.partitionStrategyFile = strategy.toString();
        TestHelpers.assertThrows((String)"Should reject incompatible partition strategy", ValidationException.class, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                TestCreateDatasetWithExistingData.this.command.run();
                return null;
            }
        });
        Assert.assertTrue((boolean)strategy.delete());
    }

    @Test
    public void testCreateFromExistingWithPartitionAndSchemaUpdate() throws Exception {
        Schema versionAdded = (Schema)SchemaBuilder.record((String)"User").fields().optionalLong("id").optionalString("username").optionalString("email").name("v").type().longType().longDefault(1L).endRecord();
        File avsc = new File("target/user_version_added.avsc");
        FileWriter writer = new FileWriter(avsc);
        writer.append(versionAdded.toString());
        writer.close();
        PartitionStrategy versionStrategy = new PartitionStrategy.Builder().identity("v", "version").build();
        File strategy = new File("target/strategy.json");
        writer = new FileWriter(strategy);
        writer.append(versionStrategy.toString());
        writer.close();
        this.command.datasets = Lists.newArrayList((Object[])new String[]{existingPartitionedURI});
        this.command.avroSchemaFile = avsc.toString();
        this.command.partitionStrategyFile = strategy.toString();
        this.command.run();
        ((Logger)Mockito.verify((Object)this.console)).debug(Matchers.contains((String)"Created"), Matchers.eq((Object)existingPartitionedURI));
        Dataset users = (Dataset)Datasets.load((String)existingPartitionedURI);
        Assert.assertEquals((String)"Schema should match", (Object)versionAdded, (Object)users.getDescriptor().getSchema());
        Assert.assertEquals((String)"Should be partitioned with a provided partitioner", (Object)versionStrategy, (Object)users.getDescriptor().getPartitionStrategy());
        Assert.assertEquals((String)"Should be Parquet", (Object)Formats.PARQUET, (Object)users.getDescriptor().getFormat());
        Assert.assertTrue((boolean)avsc.delete());
        Assert.assertTrue((boolean)strategy.delete());
    }
}

